/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.maven.plugins.tpi;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class PluginClassifier {
    public static final String PACAKGE_TPI_EXTENSION_NAME = "tpi";
    private static final String DIMENSION_SPLIT = ";";
    private static final String TUPLE_SPLIT = "_";
    private final String classifier;
    private Map<String, String> dimension;
    public static final NoneClassifier NONE_CLASSIFIER = new NoneClassifier();
    private static final String MATCH_ALL_CLASSIFIER_VAL = "*";
    public static final PluginClassifier MATCH_ALL_CLASSIFIER = new PluginClassifier("*"){

        @Override
        public final boolean match(String requiredFrom, PluginClassifier candidateClassifier) {
            return true;
        }

        @Override
        protected void validate() {
        }

        @Override
        public Map<String, String> dimensionMap() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTPIPluginName(String tpiName) {
            return tpiName;
        }
    };
    public static final Comparator<PluginClassifier> DESCENDING = new Comparator<PluginClassifier>(){

        @Override
        public int compare(PluginClassifier o1, PluginClassifier o2) {
            return o1.classifier.compareTo(o2.classifier);
        }
    };

    public static boolean isNoneClassifier(PluginClassifier classifier) {
        return classifier instanceof NoneClassifier;
    }

    public static PluginClassifier create(String classifier) {
        if (MATCH_ALL_CLASSIFIER_VAL.equals(classifier)) {
            return MATCH_ALL_CLASSIFIER;
        }
        return new PluginClassifier(classifier);
    }

    private PluginClassifier(String classifier) {
        this.classifier = Objects.requireNonNull(classifier, "param classifier can not be empty");
        this.validate();
    }

    protected void validate() {
        if (MATCH_ALL_CLASSIFIER_VAL.equals(this.classifier)) {
            throw new IllegalStateException("prop classifier is illegal:" + this.classifier);
        }
    }

    public PluginClassifier(Map<String, String> dimension) {
        this(PluginClassifier.validateDimension(dimension).entrySet().stream().map(d -> (String)d.getKey() + TUPLE_SPLIT + (String)d.getValue()).collect(Collectors.joining(DIMENSION_SPLIT)));
    }

    public static Map<String, String> validateDimension(Map<String, String> dimension) {
        if (dimension == null || dimension.isEmpty()) {
            throw new IllegalArgumentException("param dimension can not be empty");
        }
        return dimension;
    }

    public String getTPIPluginName(String tpiName, String extension) {
        return this.getTPIPluginName(tpiName) + extension;
    }

    public String getTPIPluginName(String tpiName) {
        return tpiName + TUPLE_SPLIT + StringUtils.replace((String)this.classifier, (String)DIMENSION_SPLIT, (String)TUPLE_SPLIT);
    }

    public static void validate(String requiredFrom, String dependencyForPlugin, Optional<PluginClassifier> dptCandidate, Optional<PluginClassifier> ba) {
        if (dptCandidate.isPresent() ^ ba.isPresent() && dptCandidate.isPresent()) {
            throw new IllegalStateException("\nrequired from [" + requiredFrom + "] for [" + dependencyForPlugin + "] of Candidate classifier[" + dptCandidate.get().getClassifier() + "] present status:" + dptCandidate.isPresent() + " must same with Owner classifier prestent status:" + ba.isPresent());
        }
    }

    public String getClassifier() {
        return this.classifier;
    }

    public Map<String, String> dimensionMap() {
        if (this.dimension == null) {
            this.dimension = new HashMap<String, String>();
            for (String dim : StringUtils.split((String)this.classifier, (String)DIMENSION_SPLIT)) {
                String[] tuple = StringUtils.split((String)dim, (String)TUPLE_SPLIT);
                if (tuple.length != 2) {
                    throw new IllegalStateException("the format of classifier is illegal:" + this.classifier);
                }
                this.dimension.put(tuple[0], tuple[1]);
            }
            if (this.dimension.isEmpty()) {
                throw new IllegalStateException("dimension can not be empty,classifier:" + this.classifier);
            }
            this.dimension = Collections.unmodifiableMap(this.dimension);
        }
        return this.dimension;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginClassifier that = (PluginClassifier)o;
        return StringUtils.equals((String)this.classifier, (String)that.classifier);
    }

    public int hashCode() {
        return this.classifier.hashCode();
    }

    public boolean match(String requiredFrom, PluginClassifier candidateClassifier) {
        Map<String, String> dimension = this.dimensionMap();
        for (Map.Entry<String, String> candidateDim : candidateClassifier.dimensionMap().entrySet()) {
            String dimVal = dimension.get(candidateDim.getKey());
            if (StringUtils.isEmpty((String)dimVal)) {
                throw new IllegalStateException("requiredFrom:" + requiredFrom + " candidate dim:" + candidateDim.getKey() + "[" + candidateClassifier.classifier + "] is not contain in [" + this.classifier + "]");
            }
            if (StringUtils.equals((String)dimVal, (String)candidateDim.getValue())) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.classifier;
    }

    private static final class NoneClassifier
    extends PluginClassifier {
        public NoneClassifier() {
            super("");
        }
    }
}

