/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.manage.common;

import com.qlangtech.tis.config.BasicConfig;
import com.qlangtech.tis.org.apache.commons.io.FileUtils;
import com.qlangtech.tis.realtime.utils.NetUtils;
import com.qlangtech.tis.utils.TisMetaProps;
import com.qlangtech.tis.web.start.TisAppLaunch;
import com.qlangtech.tis.web.start.TisSubModule;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config
extends BasicConfig {
    public static final String KEY_TIS_ADDRESS = "tisAddress";
    public static final String KEY_TIS_HTTP_Host = "tisHTTPHost";
    public static final String KEY_ENV_TIS_HOME = "TIS_HOME";
    public static final String SYSTEM_KEY_LOGBACK_PATH_KEY = "logback.configurationFile";
    public static final String SYSTEM_KEY_LOGBACK_PATH_VALUE = "logback-datax.xml";
    public static final String SYSTEM_KEY__LOGBACK_HUDI = "logback-hudi.xml";
    public static final String KEY_TIS_PLUGIN_ROOT = "plugins";
    public static final String EXEC_LOCAL_LOGGER_FILE_PATH = "localLoggerFilePath";
    private static final Logger logger = LoggerFactory.getLogger(Config.class);
    public static final String SUB_DIR_LIBS = "libs";
    public static final String LIB_PLUGINS_PATH = "libs/plugins";
    public static final String PLUGIN_LIB_DIR = "WEB-INF/lib";
    public static final String TIS_PUB_PLUGINS_DOC_URL = "http://tis.pub/docs/plugin/plugins/#";
    public static final String bundlePath = StringUtils.defaultIfEmpty((String)System.getenv("tisCfgBundlePath"), (String)"tis-web-config/config");
    public static final String bundlePathClasspath = bundlePath + ".properties";
    public static final String KEY_TIS_DATASOURCE_TYPE = "tis.datasource.type";
    public static final String KEY_TIS_DATASOURCE_DBNAME = "tis.datasource.dbname";
    public static final String S4TOTALPAY = "search4totalpay";
    public static final String KEY_ASSEMBLE_HOST = "assemble.host";
    public static final String KEY_DEPLOY_MODE = "deploy.mode";
    public static final String KEY_TIS_HOST = "tis.host";
    public static final String KEY_PLUGIN_METAS = "pluginMetas";
    public static final String KEY_RUNTIME = "runtime";
    public static final String KEY_JAVA_RUNTIME_PROP_ENV_PROPS = "env_props";
    public static final String SUB_DIR_CFG_REPO = "cfg_repo";
    public static final String QLANGTECH_PACKAGE = "com.qlangtech";
    private static final String GENERATE_PARENT_PACKAGE = "com.qlangtech.tis.realtime.transfer";
    public static final String DEFAULT_DATA_DIR = "/opt/data/tis";
    private static Config config;
    public static final String KEY_DATA_DIR = "data.dir";
    private final String tisHost;
    private final String runtime;
    private final String deployMode;
    private File dataDir;
    private final String assembleHost;
    private final TisDbConfig dbCfg;
    private static final Set<String> localDftValsKeys;
    private final P propGetter = P.create();
    private static final ThreadLocal<String> threadContext;
    public static String tisHttpHost;

    public static void main(String[] args) {
        System.out.println(Config.class.getResource("/"));
    }

    public static File getPluginLibDir(String pluginName, boolean validateExist) {
        File libDir = new File(Config.getDataDir(), "libs/plugins/" + pluginName + "/WEB-INF/lib");
        if (validateExist && (!libDir.exists() || libDir.isFile())) {
            throw new IllegalStateException("dir " + pluginName + " is illegal:" + libDir.getAbsolutePath());
        }
        return libDir;
    }

    public static File getPluginLibDir(String pluginName) {
        return Config.getPluginLibDir(pluginName, true);
    }

    public static TisMetaProps getMetaProps() {
        return TisMetaProps.getInstance();
    }

    public static File setDataDir(String path) {
        System.setProperty(KEY_DATA_DIR, path);
        Config.getInstance().dataDir = new File(path);
        return Config.getInstance().dataDir;
    }

    public static File setTestDataDir() {
        String dataDir = null;
        dataDir = System.getProperty(KEY_DATA_DIR);
        if (dataDir != null) {
            throw new RuntimeException("dataDir:" + dataDir + " must be empty");
        }
        try {
            File tmp = new File("/tmp/tis");
            FileUtils.deleteQuietly(tmp);
            FileUtils.forceMkdir(tmp);
            Config.setDataDir(tmp.getAbsolutePath());
            return tmp;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void visitKeyValPair(Consumer<Map.Entry<String, String>> consumer) {
        Map<String, String> pairs = this.getImportKV();
        for (Map.Entry<String, String> e : pairs.entrySet()) {
            consumer.accept(e);
        }
    }

    private Map<String, String> getImportKV() {
        HashMap<String, String> pairs = new HashMap<String, String>(){

            @Override
            public String put(String key, String value) {
                if (StringUtils.isEmpty((String)value)) {
                    return null;
                }
                return super.put(key, value);
            }
        };
        pairs.put(KEY_ASSEMBLE_HOST, this.assembleHost);
        pairs.put(KEY_TIS_HOST, this.tisHost);
        pairs.put(KEY_RUNTIME, this.runtime);
        pairs.put(KEY_TIS_DATASOURCE_TYPE, this.dbCfg.dbtype.token);
        pairs.put(KEY_TIS_DATASOURCE_DBNAME, this.dbCfg.dbname);
        pairs.put(KEY_DEPLOY_MODE, this.deployMode);
        pairs.put("log.dir", TisAppLaunch.getLogDir().getAbsolutePath());
        pairs.put("tis.launch.port", String.valueOf(TisSubModule.TIS_CONSOLE.getLaunchPort()));
        return pairs;
    }

    public Map<String, String> getAllKV() {
        HashMap<String, String> kvs = new HashMap<String, String>(this.getImportKV());
        kvs.put(KEY_DATA_DIR, Config.getDataDir(true).getAbsolutePath());
        return kvs;
    }

    public static boolean isStandaloneMode() {
        return TisAppLaunch.isTestMock() || "standalone".equalsIgnoreCase(Config.getInstance().deployMode);
    }

    public static File getMetaCfgDir() {
        File dir = Config.getDataDir();
        return new File(dir, SUB_DIR_CFG_REPO);
    }

    public static File getPluginCfgDir() {
        return new File(Config.getMetaCfgDir(), "tis_plugin_config");
    }

    public static File getLibDir() {
        File dir = Config.getDataDir();
        return new File(dir, SUB_DIR_LIBS);
    }

    public static File getDataDir() {
        return Config.getDataDir(true);
    }

    public static File getTisHome() {
        File tisHome = new File(Objects.requireNonNull(System.getenv(KEY_ENV_TIS_HOME), "env TIS_HOME has not been set"));
        if (!tisHome.exists() || !tisHome.isDirectory()) {
            throw new IllegalStateException("tisHomeDir:" + tisHome.getAbsolutePath() + " is not illegal");
        }
        return tisHome;
    }

    public static File getDataDir(boolean valiate) {
        File dir = null;
        try {
            dir = Config.getInstance().dataDir();
        }
        catch (Throwable e) {
            logger.warn("can not get dataDir from config instance:" + e.getMessage());
            dir = new File(System.getProperty(KEY_DATA_DIR, DEFAULT_DATA_DIR));
        }
        if (!(!valiate || dir.isDirectory() && dir.exists())) {
            throw new IllegalStateException("dir:" + dir.getAbsolutePath() + " is invalid DATA DIR");
        }
        return dir;
    }

    public File dataDir() {
        return this.dataDir;
    }

    public void consumeOriginSource(Consumer<InputStream> originSource) {
        try (InputStream cfgSource = this.propGetter.getOriginSource();){
            originSource.accept(cfgSource);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private Config() {
        this.assembleHost = this.propGetter.getString(KEY_ASSEMBLE_HOST, true);
        this.tisHost = this.propGetter.getString(KEY_TIS_HOST, true);
        this.runtime = this.propGetter.getString(KEY_RUNTIME, true);
        this.deployMode = this.propGetter.getString(KEY_DEPLOY_MODE);
        this.dataDir = new File(StringUtils.defaultIfEmpty((String)this.propGetter.getString(KEY_DATA_DIR), (String)System.getProperty(KEY_DATA_DIR, DEFAULT_DATA_DIR)));
        this.dbCfg = new TisDbConfig();
        try {
            this.dbCfg.dbtype = SysDBType.parse(this.propGetter.getString(KEY_TIS_DATASOURCE_TYPE, true));
            this.dbCfg.dbname = this.propGetter.getString(KEY_TIS_DATASOURCE_DBNAME, true);
            if (SysDBType.MySQL == this.dbCfg.dbtype) {
                this.dbCfg.port = Integer.parseInt(this.propGetter.getString("tis.datasource.port"));
                this.dbCfg.url = this.propGetter.getString("tis.datasource.url");
                this.dbCfg.userName = this.propGetter.getString("tis.datasource.username");
                this.dbCfg.password = this.propGetter.getString("tis.datasource.password");
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("please check the tis datasource cfg", e);
        }
    }

    protected String getAsbHost() {
        return this.assembleHost;
    }

    public String getTISHost() {
        return this.tisHost;
    }

    public String getRuntime() {
        return this.runtime;
    }

    public static void setThreadContextTisHost(String tishost) {
        threadContext.set(tishost);
    }

    public static String getConfigRepositoryHost() {
        String consoleHttpHost = StringUtils.defaultIfEmpty((String)tisHttpHost, (String)Config.getTISConsoleHttpHost());
        return consoleHttpHost + TisSubModule.TIS_CONSOLE.servletContext;
    }

    public static String getTISConsoleHttpHost() {
        String tisHost = null;
        tisHost = threadContext.get();
        if (tisHost == null) {
            tisHost = Config.getBaseConfig().getTISHost();
        } else {
            threadContext.remove();
        }
        return "http://" + tisHost + ":" + TisSubModule.TIS_CONSOLE.getLaunchPort();
    }

    private static String getTISAssembleHttpHost() {
        return "http://" + Config.getAssembleHost() + ":" + TisSubModule.TIS_ASSEMBLE.getLaunchPort();
    }

    public static String getAssembleHttpHost() {
        return StringUtils.defaultIfEmpty((String)tisHttpHost, (String)Config.getTISAssembleHttpHost()) + TisSubModule.TIS_ASSEMBLE.servletContext;
    }

    public static TisDbConfig getDbCfg() {
        return Config.getInstance().getDbConfig();
    }

    public TisDbConfig getDbConfig() {
        return this.dbCfg;
    }

    public static String getTerminatorRepositoryOnline() {
        throw new UnsupportedOperationException();
    }

    public static TestCfgStream openTestCfgStream() throws IOException {
        String propertiesFile = "tis-web-config/config.properties";
        File f = new File("../../../" + propertiesFile);
        if (f.exists()) {
            return new TestCfgStream(f);
        }
        f = new File("../../" + propertiesFile);
        if (f.exists()) {
            return new TestCfgStream(f);
        }
        f = new File("../" + propertiesFile);
        if (f.exists()) {
            return new TestCfgStream(f);
        }
        f = new File(propertiesFile);
        return new TestCfgStream(f);
    }

    public static String getGenerateParentPackage() {
        return GENERATE_PARENT_PACKAGE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Config getInstance() {
        if (config != null) return config;
        Class<Config> clazz = Config.class;
        synchronized (Config.class) {
            if (config != null) return config;
            config = new Config();
            // ** MonitorExit[var0] (shouldn't be in output)
            return config;
        }
    }

    public static void setConfig(Config cfg) {
        config = cfg;
    }

    static {
        localDftValsKeys = new HashSet<String>();
        threadContext = new ThreadLocal();
    }

    public static class FuncGroup {
        private final Integer key;
        private final String name;

        public boolean equals(Object obj) {
            return this.hashCode() == obj.hashCode();
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public FuncGroup(Integer key, String name) {
            this.key = key;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public Integer getKey() {
            return this.key;
        }
    }

    public static class TisDbConfig {
        public SysDBType dbtype;
        public String dbname;
        public int port;
        public String url;
        public String userName;
        public String password;

        public String toString() {
            return "{dbtype='" + this.dbtype + "', dbname='" + this.dbname + "', port=" + this.port + ", url='" + this.url + "', userName='" + this.userName + "'}";
        }
    }

    private static abstract class LocalResBasedPropertyGetter
    extends P {
        private LocalResBasedPropertyGetter() {
        }

        @Override
        protected final String getProp(String key) {
            if (TisAppLaunch.isTestMock()) {
                return this.getPropValue(key);
            }
            if ((Config.KEY_ASSEMBLE_HOST.equals(key) || Config.KEY_TIS_HOST.equals(key)) && !BasicConfig.inDockerContainer()) {
                return NetUtils.getHost();
            }
            return this.getPropValue(key);
        }

        protected abstract String getPropValue(String var1);
    }

    private static abstract class P {
        public static P create() {
            if (Boolean.getBoolean(Config.KEY_JAVA_RUNTIME_PROP_ENV_PROPS)) {
                return new P(){

                    @Override
                    protected InputStream getOriginSource() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    protected String getProp(String key) {
                        if (localDftValsKeys.contains(key)) {
                            return "defaultVal";
                        }
                        if (Config.KEY_TIS_DATASOURCE_DBNAME.equals(key)) {
                            return "tis_console_db";
                        }
                        if (Config.KEY_TIS_DATASOURCE_TYPE.equals(key)) {
                            return SysDBType.DERBY.token;
                        }
                        return StringUtils.defaultIfEmpty((String)System.getenv(key), (String)System.getProperty(key));
                    }
                };
            }
            try {
                final ResourceBundle bundle = ResourceBundle.getBundle(bundlePath);
                final ClassLoader classLoader = Config.class.getClassLoader();
                return new LocalResBasedPropertyGetter(){

                    @Override
                    protected InputStream getOriginSource() {
                        InputStream source = classLoader.getResourceAsStream(bundlePathClasspath);
                        if (source == null) {
                            throw new NullPointerException("bundlePathClasspath:" + bundlePathClasspath + " relevant inputStream can not be null,classpath root:" + classLoader.getResource("/"));
                        }
                        return source;
                    }

                    @Override
                    protected String getPropValue(String key) {
                        return bundle.getString(key);
                    }
                };
            }
            catch (Throwable ee) {
                final Properties props = new Properties();
                try {
                    final TestCfgStream cfgStream = Config.openTestCfgStream();
                    cfgStream.validate(ee);
                    try (InputStream input = cfgStream.propsStream;){
                        props.load(input);
                    }
                    TisAppLaunch.setTest((boolean)true);
                    return new LocalResBasedPropertyGetter(){

                        @Override
                        protected InputStream getOriginSource() {
                            try {
                                return FileUtils.openInputStream(cfgStream.propsFile);
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }

                        @Override
                        protected String getPropValue(String key) {
                            return props.getProperty(key);
                        }
                    };
                }
                catch (IOException ex) {
                    StringBuffer errMsg = new StringBuffer();
                    errMsg.append("config file err:\n");
                    errMsg.append("has tried twice\n");
                    errMsg.append("second err:").append(ex.getMessage()).append("\n");
                    throw new RuntimeException(errMsg.toString());
                }
            }
        }

        public final String getString(String key) {
            return this.getString(key, false);
        }

        public final String getString(String key, boolean notEmpty) {
            String value = null;
            try {
                value = this.getProp(key);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (StringUtils.isEmpty((String)value) && notEmpty) {
                throw new IllegalStateException("key:" + key + " relevant can not be empty");
            }
            return value;
        }

        protected abstract String getProp(String var1);

        protected abstract InputStream getOriginSource();
    }

    public static class TestCfgStream {
        private final File propsFile;
        private InputStream propsStream;

        public InputStream getPropsStream() {
            return this.propsStream;
        }

        public File getPropsFile() {
            return this.propsFile;
        }

        public void validate(Throwable ee) {
            if (this.propsStream == null) {
                URL cpRoot = Config.class.getResource("/");
                URL cpThreadRoot = Thread.currentThread().getContextClassLoader().getResource("/");
                throw new IllegalStateException("file relevant stream is null,confFile:" + this.propsFile.getAbsolutePath() + ",current classpath root url:" + String.valueOf(cpRoot) + " of classloader:" + Config.class.getClassLoader() + ",thread classpath:" + String.valueOf(cpThreadRoot), ee);
            }
        }

        public TestCfgStream(File propsFile) {
            this.propsFile = propsFile;
            try {
                if (propsFile.exists()) {
                    this.setPropsStream(FileUtils.openInputStream(propsFile));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private TestCfgStream setPropsStream(InputStream propsStream) {
            this.propsStream = propsStream;
            return this;
        }
    }

    public static class ConfigExport
    extends BasicConfig {
        protected String getAsbHost() {
            return Config.getInstance().assembleHost;
        }

        public String getTISHost() {
            return Config.getInstance().tisHost;
        }

        public Map<String, String> getAllKV() {
            return Config.getInstance().getAllKV();
        }
    }

    public static enum SysDBType {
        MySQL("mysql"),
        DERBY("derby");

        String token;

        private SysDBType(String token) {
            this.token = token;
        }

        public String getToken() {
            return this.token;
        }

        public static SysDBType parse(String token) {
            for (SysDBType type : SysDBType.values()) {
                if (!type.token.equalsIgnoreCase(token)) continue;
                return type;
            }
            throw new IllegalStateException("illegal token:" + token);
        }
    }
}

