/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.job.common;

import com.qlangtech.tis.job.common.IPipelineExecContext;
import com.qlangtech.tis.job.common.JobParams;
import org.apache.commons.lang.StringUtils;
import org.slf4j.MDC;

public interface JobCommon
extends JobParams {
    public static void setMDC(IPipelineExecContext pec) {
        MDC.put((String)"taskid", (String)String.valueOf(pec.getTaskId()));
        if (pec.hasIndexName()) {
            MDC.put((String)"app", (String)pec.getIndexName());
        }
    }

    public static void setMDC(int taskId) {
        JobCommon.setMDC(taskId, null);
    }

    public static void setMDC(final int taskId, final String pipelineName) {
        JobCommon.setMDC(new IPipelineExecContext(){

            @Override
            public int getTaskId() {
                return taskId;
            }

            @Override
            public String getIndexName() {
                if (!this.hasIndexName()) {
                    throw new IllegalStateException("pipelineName is empty");
                }
                return pipelineName;
            }

            @Override
            public boolean hasIndexName() {
                return StringUtils.isNotEmpty((String)pipelineName);
            }
        });
    }
}

