/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.fullbuild.taskflow;

import com.qlangtech.tis.assemble.FullbuildPhase;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public abstract class DataflowTask {
    protected final String id;

    protected DataflowTask(String id) {
        if (StringUtils.isEmpty((String)id)) {
            throw new IllegalArgumentException("parm id can not be blank");
        }
        this.id = id;
    }

    public abstract FullbuildPhase phase();

    public abstract String getIdentityName();

    public abstract void run() throws Exception;

    protected final void signTaskSuccess() {
        this.getTaskWorkStatus().put(this.id, true);
    }

    protected final void signTaskFaild() {
        this.getTaskWorkStatus().put(this.id, false);
    }

    protected abstract Map<String, Boolean> getTaskWorkStatus();

    public String toString() {
        return this.id;
    }
}

