/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.fullbuild.taskflow;

import com.qlangtech.tis.exec.ExecChainContextUtils;
import com.qlangtech.tis.fs.ITaskContext;
import com.qlangtech.tis.fullbuild.taskflow.DataflowTask;
import com.qlangtech.tis.order.center.IJoinTaskContext;
import com.qlangtech.tis.sql.parser.TabPartitions;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public abstract class AdapterTask
extends DataflowTask {
    public static final String KEY_TASK_WORK_STATUS = "TaskWorkStatus";
    private ITaskContext taskContext;
    private IJoinTaskContext joinExecContext;

    protected final TabPartitions getDumpPartition() {
        TabPartitions dumpPartition = ExecChainContextUtils.getDependencyTablesPartitions(this.joinExecContext);
        return dumpPartition;
    }

    @Override
    protected Map<String, Boolean> getTaskWorkStatus() {
        return AdapterTask.createTaskWorkStatus(this.joinExecContext);
    }

    public static Map<String, Boolean> createTaskWorkStatus(IJoinTaskContext chainContext) {
        HashMap taskWorkStatus = (HashMap)chainContext.getAttribute(KEY_TASK_WORK_STATUS);
        if (taskWorkStatus == null) {
            taskWorkStatus = new HashMap();
            chainContext.setAttribute(KEY_TASK_WORK_STATUS, taskWorkStatus);
        }
        return taskWorkStatus;
    }

    public AdapterTask(String id) {
        super(id);
    }

    public abstract String getName();

    protected <T> T getTaskContextObj() {
        Objects.requireNonNull(this.taskContext, "task content can not be null");
        return this.taskContext.getObj();
    }

    @Override
    public void run() throws Exception {
        try {
            this.executeTask(this.getName());
            this.signTaskSuccess();
        }
        catch (Exception e) {
            this.signTaskFaild();
            throw e;
        }
    }

    protected abstract void executeTask(String var1);

    public IJoinTaskContext getExecContext() {
        return this.joinExecContext;
    }

    public void setContext(IJoinTaskContext context, ITaskContext taskContext) {
        Objects.requireNonNull(context, "param context can not be null");
        Objects.requireNonNull(taskContext, "param taskContext can not be null");
        this.joinExecContext = context;
        this.taskContext = taskContext;
    }
}

