/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.fullbuild.indexbuild.impl;

import com.qlangtech.tis.fullbuild.indexbuild.IDumpTable;
import com.qlangtech.tis.fullbuild.indexbuild.TaskContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobConfParams {
    private static final Logger logger = LoggerFactory.getLogger(JobConfParams.class);
    private Map<String, String> params = new HashMap<String, String>();

    public static JobConfParams createTabDumpParams(TaskContext taskContext, IDumpTable table, long startTime, String dumpFactoryName) {
        JobConfParams jobConf = new JobConfParams();
        Objects.requireNonNull(dumpFactoryName, "paramConfigName can not be null");
        String jobName = table.getDbName() + "." + table.getTableName();
        jobConf.set("dump_table_dump_factory_name", dumpFactoryName);
        jobConf.set("job_type", "tabledump");
        jobConf.set("dump_starttime", String.valueOf(startTime));
        jobConf.set("dump_job_name", jobName);
        jobConf.set("dump_tableName", table.getTableName());
        jobConf.set("dump_db_name", table.getDbName());
        jobConf.set("taskid", String.valueOf(taskContext.getTaskId()));
        jobConf.set("dump_force", "true");
        return jobConf;
    }

    public void set(String key, String value) {
        this.params.put(key, value);
    }

    public String[] paramsArray() {
        List<String> params = this.paramsList();
        return params.toArray(new String[params.size()]);
    }

    private List<String> paramsList() {
        ArrayList<String> plist = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.params.entrySet()) {
            if (StringUtils.isBlank((String)entry.getValue())) continue;
            plist.add("-" + entry.getKey());
            plist.add(entry.getValue());
        }
        return plist;
    }

    public String paramSerialize() {
        return this.paramsList().stream().collect(Collectors.joining(" "));
    }
}

