/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.fullbuild.indexbuild;

import com.qlangtech.tis.build.metrics.Counters;
import com.qlangtech.tis.build.metrics.Messages;
import com.qlangtech.tis.cloud.ICoordinator;
import com.qlangtech.tis.sql.parser.tuple.creator.EntityName;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public class TaskContext {
    private static final long serialVersionUID = 1L;
    private ICoordinator coordinator;
    private final Counters counters = new Counters();
    private final Messages message = new Messages();
    private final IParamGetter commandLine;
    private Integer allRowCount;

    public void setCoordinator(ICoordinator coordinator) {
        this.coordinator = coordinator;
    }

    public ICoordinator getCoordinator() {
        Objects.requireNonNull(this.coordinator, "coordinator can not be null");
        return this.coordinator;
    }

    private TaskContext(IParamGetter commandLine) {
        this.commandLine = commandLine;
    }

    public EntityName parseDumpTable() {
        return EntityName.create(this.get("dump_db_name"), this.get("dump_tableName"));
    }

    public long getStartTime() {
        try {
            return Long.parseLong(this.get("dump_starttime"));
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("please set param ITableDumpConstant.DUMP_START_TIME", e);
        }
    }

    public static TaskContext create(IParamGetter commandLine) {
        return new TaskContext(commandLine);
    }

    public static TaskContext create() {
        return TaskContext.create(new HashMap<String, String>());
    }

    public static TaskContext create(Map<String, String> params) {
        return new TaskContext(key -> (String)params.get(key));
    }

    public int getAllRowCount() {
        if (this.allRowCount == null) {
            try {
                this.allRowCount = Integer.parseInt(this.getInnerParam("indexing_row_count"));
            }
            catch (Throwable e) {
                this.allRowCount = Integer.MAX_VALUE;
            }
        }
        return this.allRowCount;
    }

    public long getIndexMakerComplete() {
        return this.counters.getCounter(Counters.Counter.DOCMAKE_COMPLETE).get();
    }

    public Counters getCounters() {
        return this.counters;
    }

    public Messages getMessages() {
        return this.message;
    }

    public String getInnerParam(String key) {
        return this.commandLine.getOptionValue(key);
    }

    public String getUserParam(String key) {
        return this.commandLine.getOptionValue(key);
    }

    public String getCollectionName() {
        String collectionName = this.get("indexing_servicename");
        if (StringUtils.isBlank((String)collectionName)) {
            throw new IllegalStateException("collection name:" + collectionName + " can not be null");
        }
        return collectionName;
    }

    public String getMapPath() {
        return this.commandLine.getOptionValue("task.map.output.path");
    }

    public String get(Object key) {
        return this.commandLine.getOptionValue(String.valueOf(key));
    }

    public Integer getTaskId() {
        return Integer.parseInt(this.get("taskid"));
    }

    public boolean equals(Object obj) {
        return obj instanceof TaskContext;
    }

    public static interface IParamGetter {
        public String getOptionValue(String var1);
    }
}

