/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.fullbuild.indexbuild;

import com.qlangtech.tis.fullbuild.indexbuild.IRemoteTaskTrigger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RemoteTaskTriggers {
    private final List<IRemoteTaskTrigger> dumpPhaseTasks = new ArrayList<IRemoteTaskTrigger>();
    private final List<IRemoteTaskTrigger> joinPhaseTasks = new ArrayList<IRemoteTaskTrigger>();
    private final ExecutorService executorService;

    public RemoteTaskTriggers(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public void addDumpPhaseTask(IRemoteTaskTrigger dumpTsk) {
        this.dumpPhaseTasks.add(dumpTsk);
    }

    public void addJoinPhaseTask(IRemoteTaskTrigger joinTsk) {
        this.joinPhaseTasks.add(joinTsk);
    }

    public Map<String, IRemoteTaskTrigger> getTriggerDict() {
        return Stream.concat(this.dumpPhaseTasks.stream(), this.joinPhaseTasks.stream()).collect(Collectors.toMap(t -> t.getTaskName(), t -> t));
    }

    public List<IRemoteTaskTrigger> getDumpPhaseTasks() {
        return Collections.unmodifiableList(this.dumpPhaseTasks);
    }

    public List<IRemoteTaskTrigger> getJoinPhaseTasks() {
        return Collections.unmodifiableList(this.joinPhaseTasks);
    }

    public void allCancel() {
        Stream.concat(this.dumpPhaseTasks.stream(), this.joinPhaseTasks.stream()).forEach(trigger -> trigger.cancel());
        this.executorService.shutdownNow();
        try {
            if (!this.executorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                this.executorService.shutdownNow();
            }
        }
        catch (InterruptedException ie) {
            this.executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

