/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.fs;

import com.qlangtech.tis.fs.FSDataInputStream;
import com.qlangtech.tis.fs.FSHistoryFileUtils;
import com.qlangtech.tis.fs.IContentSummary;
import com.qlangtech.tis.fs.IFileSplitor;
import com.qlangtech.tis.fs.IPath;
import com.qlangtech.tis.fs.IPathInfo;
import com.qlangtech.tis.fs.TISFSDataOutputStream;
import com.qlangtech.tis.sql.parser.tuple.creator.EntityName;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.regex.Pattern;

public interface ITISFileSystem {
    public static final String NAME_LOCAL_FS = "localFileSys";
    public static final Pattern DATE_PATTERN = Pattern.compile("20\\d{12}");

    default public void deleteHistoryFile(EntityName dumpTable) throws Exception {
        FSHistoryFileUtils.deleteHistoryFile(this, dumpTable);
    }

    default public void deleteHistoryFile(EntityName dumpTable, String timestamp) throws Exception {
        FSHistoryFileUtils.deleteHistoryFile(this, dumpTable, timestamp);
    }

    public IPath getRootDir();

    public String getName();

    public IPath getPath(String var1);

    public IPath getPath(IPath var1, String var2);

    public OutputStream getOutputStream(IPath var1);

    public FSDataInputStream open(IPath var1, int var2);

    public FSDataInputStream open(IPath var1);

    public TISFSDataOutputStream create(IPath var1, boolean var2, int var3) throws IOException;

    public TISFSDataOutputStream create(IPath var1, boolean var2) throws IOException;

    public boolean exists(IPath var1);

    public boolean mkdirs(IPath var1) throws IOException;

    public void copyToLocalFile(IPath var1, File var2);

    public void rename(IPath var1, IPath var2);

    public boolean copyFromLocalFile(File var1, IPath var2);

    public IFileSplitor getSplitor(IPath var1) throws Exception;

    public IContentSummary getContentSummary(IPath var1);

    public List<IPathInfo> listChildren(IPath var1);

    public List<IPathInfo> listChildren(IPath var1, IPathFilter var2);

    public IPathInfo getFileInfo(IPath var1);

    public boolean delete(IPath var1, boolean var2) throws IOException;

    public boolean delete(IPath var1) throws IOException;

    public void close();

    public <T> T unwrap();

    public static interface IPathFilter {
        public boolean accept(IPath var1);
    }
}

