/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.fs;

import com.qlangtech.tis.dump.INameWithPathGetter;
import com.qlangtech.tis.fs.IPath;
import com.qlangtech.tis.fs.IPathInfo;
import com.qlangtech.tis.fs.ITISFileSystem;
import com.qlangtech.tis.sql.parser.tuple.creator.EntityName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FSHistoryFileUtils {
    private static final Logger logger = LoggerFactory.getLogger(FSHistoryFileUtils.class);

    public static void deleteHistoryFile(ITISFileSystem fileSystem, EntityName dumpTable) throws Exception {
        FSHistoryFileUtils.deleteMetadata(fileSystem, dumpTable);
        FSHistoryFileUtils.deleteHdfsFile(fileSystem, INameWithPathGetter.create(dumpTable), false);
        FSHistoryFileUtils.deleteHdfsFile(fileSystem, INameWithPathGetter.create(dumpTable), true);
    }

    public static void removeHistoryBuildFile(ITISFileSystem fileSystem, String indexName) {
        try {
            FSHistoryFileUtils.deleteHdfsFile(fileSystem, () -> indexName, true);
        }
        catch (IOException e) {
            throw new RuntimeException("delete index:" + indexName + " history build file", e);
        }
    }

    public static void deleteHistoryFile(ITISFileSystem fileSystem, EntityName dumpTable, String timestamp) throws Exception {
        FSHistoryFileUtils.deleteMetadata(fileSystem, dumpTable, timestamp);
        FSHistoryFileUtils.deleteHdfsFile(fileSystem, dumpTable, false, timestamp);
        FSHistoryFileUtils.deleteHdfsFile(fileSystem, dumpTable, true, timestamp);
    }

    private static void deleteHdfsFile(ITISFileSystem fileSystem, EntityName dumpTable, boolean isBuildFile, String timestamp) throws IOException {
        FSHistoryFileUtils.deleteHdfsFile(fileSystem, INameWithPathGetter.create(dumpTable), isBuildFile, r -> StringUtils.equals((String)r.getName(), (String)timestamp), 0);
    }

    private static void deleteHdfsFile(ITISFileSystem fileSystem, INameWithPathGetter entityName, boolean isBuildFile) throws IOException {
        FSHistoryFileUtils.deleteHdfsFile(fileSystem, entityName, isBuildFile, r -> true, 2);
    }

    private static void deleteMetadata(ITISFileSystem fileSystem, EntityName dumpTable) throws Exception {
        FSHistoryFileUtils.deleteMetadata(fileSystem, dumpTable, r -> true, 2);
    }

    private static void deleteMetadata(ITISFileSystem fileSystem, EntityName dumpTable, String timestamp) throws Exception {
        if (StringUtils.isEmpty((String)timestamp)) {
            throw new IllegalArgumentException("param timestamp can not be null");
        }
        FSHistoryFileUtils.deleteMetadata(fileSystem, dumpTable, r -> StringUtils.equals((String)r.getName(), (String)timestamp), 0);
    }

    private static void deleteMetadata(ITISFileSystem fileSystem, EntityName dumpTable, ITISFileSystem.IPathFilter pathFilter, int maxPartitionSave) throws Exception {
        String hdfsPath = FSHistoryFileUtils.getJoinTableStorePath(fileSystem.getRootDir(), INameWithPathGetter.create(dumpTable)) + "/all";
        logger.info("hdfsPath:{}", (Object)hdfsPath);
        ITISFileSystem fileSys = fileSystem;
        IPath parent = fileSys.getPath(hdfsPath);
        if (!fileSys.exists(parent)) {
            return;
        }
        List<IPathInfo> child = fileSys.listChildren(parent, pathFilter);
        ArrayList<PathInfo> timestampList = new ArrayList<PathInfo>();
        for (IPathInfo c : child) {
            Matcher matcher = ITISFileSystem.DATE_PATTERN.matcher(c.getPath().getName());
            if (!matcher.matches()) continue;
            PathInfo pathinfo = new PathInfo();
            pathinfo.pathName = c.getPath().getName();
            pathinfo.timeStamp = Long.parseLong(matcher.group());
            timestampList.add(pathinfo);
        }
        if (timestampList.size() > 0) {
            FSHistoryFileUtils.deleteOldHdfsfile(fileSys, parent, timestampList, maxPartitionSave);
        }
    }

    private static void deleteHdfsFile(ITISFileSystem fileSystem, INameWithPathGetter dumpTable, boolean isBuildFile, ITISFileSystem.IPathFilter filter, int maxPartitionSave) throws IOException {
        String hdfsPath = FSHistoryFileUtils.getJoinTableStorePath(fileSystem.getRootDir(), dumpTable) + "/all";
        ITISFileSystem fileSys = fileSystem;
        int group = 0;
        List<IPathInfo> children = null;
        while (true) {
            IPath parent = fileSys.getPath(hdfsPath + "/" + group++);
            if (isBuildFile) {
                parent = fileSys.getPath(parent, "output");
            }
            if (!fileSys.exists(parent)) break;
            children = fileSys.listChildren(parent, filter);
            ArrayList<PathInfo> dumpTimestamps = new ArrayList<PathInfo>();
            for (IPathInfo f : children) {
                try {
                    PathInfo pathinfo = new PathInfo();
                    pathinfo.pathName = f.getPath().getName();
                    pathinfo.timeStamp = Long.parseLong(f.getPath().getName());
                    dumpTimestamps.add(pathinfo);
                }
                catch (Throwable throwable) {}
            }
            FSHistoryFileUtils.deleteOldHdfsfile(fileSys, parent, dumpTimestamps, maxPartitionSave);
        }
    }

    public static void deleteOldHdfsfile(ITISFileSystem fileSys, IPath parent, List<PathInfo> timestampList, int maxPartitionSave) throws IOException {
        FSHistoryFileUtils.sortTimestamp(timestampList);
        IPath toDelete = null;
        for (int index = maxPartitionSave; index < timestampList.size(); ++index) {
            toDelete = fileSys.getPath(parent, timestampList.get((int)index).pathName);
            if (!fileSys.exists(toDelete)) {
                logger.warn("toDelete path:`" + toDelete + "` is not exist,skip the delete process ");
                continue;
            }
            logger.info("history old file path:" + toDelete.toString() + " delete,success:" + fileSys.delete(toDelete, true) + ",getMaxPartitionSave:" + maxPartitionSave);
        }
    }

    private static void sortTimestamp(List<PathInfo> timestampList) {
        Collections.sort(timestampList, (o1, o2) -> (int)(o2.timeStamp - o1.timeStamp));
    }

    public static String getJoinTableStorePath(IPath rootDir, INameWithPathGetter pathGetter) {
        Objects.requireNonNull(rootDir, "rootDir can not be null");
        return String.valueOf(rootDir) + "/" + pathGetter.getNameWithPath();
    }

    public static class PathInfo {
        private long timeStamp;
        private String pathName;

        public long getTimeStamp() {
            return this.timeStamp;
        }

        public void setTimeStamp(long timeStamp) {
            this.timeStamp = timeStamp;
        }

        public String getPathName() {
            return this.pathName;
        }

        public void setPathName(String pathName) {
            this.pathName = pathName;
        }
    }
}

