/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.coredefine.module.action.impl;

import com.qlangtech.tis.config.k8s.ReplicasSpec;
import com.qlangtech.tis.coredefine.module.action.IDeploymentDetail;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RcDeployment
extends ReplicasSpec
implements IDeploymentDetail {
    private final String name;
    private long creationTimestamp;
    private ReplicationControllerStatus status;
    private List<PodStatus> pods = new ArrayList<PodStatus>();
    final Map<String, String> envs = new HashMap<String, String>();
    private String dockerImage;

    public RcDeployment(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ReplicationControllerStatus getStatus() {
        return this.status;
    }

    public void setStatus(ReplicationControllerStatus status) {
        this.status = status;
    }

    public String getDockerImage() {
        return this.dockerImage;
    }

    public void addPod(PodStatus podStat) {
        this.pods.add(podStat);
    }

    public List<PodStatus> getPods() {
        return this.pods;
    }

    public void setDockerImage(String dockerImage) {
        this.dockerImage = dockerImage;
    }

    public void addEnv(String key, String val) {
        this.envs.put(key, val);
    }

    public Map<String, String> getEnvs() {
        return this.envs;
    }

    public long getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public void setCreationTimestamp(long creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
    }

    @Override
    public void accept(IDeploymentDetail.IDeploymentDetailVisitor visitor) {
        visitor.visit(this);
    }

    public static class PodStatus {
        private String name;
        private String phase;
        private int restartCount;
        private long startTime;

        public String getName() {
            return this.name;
        }

        public int getRestartCount() {
            return this.restartCount;
        }

        public void setRestartCount(int restartCount) {
            this.restartCount = restartCount;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPhase() {
            return this.phase;
        }

        public void setPhase(String phase) {
            this.phase = phase;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public void setStartTime(long startTime) {
            this.startTime = startTime;
        }
    }

    public static class ReplicationControllerStatus {
        private Integer availableReplicas;
        private Integer fullyLabeledReplicas;
        private Long observedGeneration;
        private Integer readyReplicas;
        private Integer replicas;

        public Integer getAvailableReplicas() {
            return this.availableReplicas;
        }

        public void setAvailableReplicas(Integer availableReplicas) {
            this.availableReplicas = availableReplicas;
        }

        public Integer getFullyLabeledReplicas() {
            return this.fullyLabeledReplicas;
        }

        public void setFullyLabeledReplicas(Integer fullyLabeledReplicas) {
            this.fullyLabeledReplicas = fullyLabeledReplicas;
        }

        public Long getObservedGeneration() {
            return this.observedGeneration;
        }

        public void setObservedGeneration(Long observedGeneration) {
            this.observedGeneration = observedGeneration;
        }

        public Integer getReadyReplicas() {
            return this.readyReplicas;
        }

        public void setReadyReplicas(Integer readyReplicas) {
            this.readyReplicas = readyReplicas;
        }

        public Integer getReplicas() {
            return this.replicas;
        }

        public void setReplicas(Integer replicas) {
            this.replicas = replicas;
        }
    }
}

