/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.coredefine.module.action.impl;

import com.qlangtech.tis.config.flink.IFlinkClusterConfig;
import com.qlangtech.tis.coredefine.module.action.IDeploymentDetail;
import com.qlangtech.tis.coredefine.module.action.IFlinkIncrJobStatus;
import com.qlangtech.tis.datax.DataXName;
import java.util.Objects;

public abstract class FlinkJobDeploymentDetails
implements IDeploymentDetail {
    private final IFlinkClusterConfig clusterCfg;
    private final IFlinkIncrJobStatus incrJobStatus;

    public static FlinkJobDeploymentDetails noneState(DataXName dataXName, IFlinkClusterConfig clusterCfg, IFlinkIncrJobStatus incrJobStatus) {
        return new NoneStateDetail(dataXName, clusterCfg, incrJobStatus);
    }

    public abstract String getJobId();

    public abstract String getJobName();

    public final String getJobManagerUrl() {
        return this.clusterCfg.getJobManagerAddress().getUrl() + "/#/job/running/" + this.getJobId() + "/overview";
    }

    public abstract boolean isRunning();

    public FlinkJobDeploymentDetails(IFlinkClusterConfig clusterCfg, IFlinkIncrJobStatus incrJobStatus) {
        this.clusterCfg = IFlinkClusterConfig.create(clusterCfg);
        this.incrJobStatus = incrJobStatus;
    }

    public IFlinkIncrJobStatus getIncrJobStatus() {
        return this.incrJobStatus;
    }

    public IFlinkClusterConfig getClusterCfg() {
        return this.clusterCfg;
    }

    @Override
    public void accept(IDeploymentDetail.IDeploymentDetailVisitor visitor) {
        visitor.visit(this);
    }

    private static class NoneStateDetail
    extends FlinkJobDeploymentDetails {
        private final DataXName dataXName;

        public NoneStateDetail(DataXName dataXName, IFlinkClusterConfig clusterCfg, IFlinkIncrJobStatus incrJobStatus) {
            super(clusterCfg, incrJobStatus);
            this.dataXName = Objects.requireNonNull(dataXName, "dataXName can not be null");
        }

        @Override
        public String getJobId() {
            return null;
        }

        @Override
        public String getJobName() {
            return this.dataXName.getPipelineName();
        }

        @Override
        public boolean isRunning() {
            return false;
        }
    }
}

