/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.coredefine.module.action;

import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class Specification {
    public static final String MEMORY_UNIT_MEGABYTE = "Mi";
    private static final Pattern p = Pattern.compile("(\\d+(\\.\\d)?)(([mGM]|Mi)?)");
    private float val;
    private String unit;

    public static Specification parse(String val) {
        Matcher m = p.matcher(val);
        if (!m.matches()) {
            throw new IllegalArgumentException("val:" + val + " is not match the pattern:" + p);
        }
        Specification s = new Specification();
        s.setVal(Float.parseFloat(m.group(1)));
        s.setUnit(m.group(3));
        return s;
    }

    public float getVal() {
        return this.val;
    }

    public boolean isUnitEmpty() {
        return StringUtils.isEmpty((String)this.unit);
    }

    public void setVal(float val) {
        this.val = val;
    }

    public int normalizeMemory() {
        return this.normalizeMemory(Optional.empty());
    }

    public int normalizeMemory(Optional<Integer> proportion) {
        float result = 0.0f;
        if (MEMORY_UNIT_MEGABYTE.equals(this.getUnit()) || "M".equals(this.getUnit())) {
            result = this.getVal();
        } else if ("G".equals(this.getUnit())) {
            result = this.getVal() * 1024.0f;
        } else {
            throw new IllegalStateException("invalid memory unit:" + this.getUnit());
        }
        float r = result;
        return proportion.map(p -> {
            if (p < 1 || p > 100) {
                throw new IllegalArgumentException("proportion:" + p + " is invalid");
            }
            return (int)(r * (float)p.intValue() / 100.0f);
        }).orElse((int)result);
    }

    public String literalVal() {
        return this.getVal() + this.getUnit();
    }

    public int normalizeCPU() {
        float result = 0.0f;
        if ("m".equals(this.getUnit())) {
            result = this.getVal();
        } else if (this.isUnitEmpty()) {
            result = this.getVal() * 1024.0f;
        } else {
            throw new IllegalStateException("invalid cpu unit:" + this.getUnit());
        }
        return (int)result;
    }

    public boolean memoryBigThan(Specification spec) {
        Objects.requireNonNull(spec, "param spec can not be null");
        return this.normalizeMemory() > spec.normalizeMemory();
    }

    public boolean cpuBigThan(Specification spec) {
        Objects.requireNonNull(spec, "param spec can not be null");
        return this.normalizeCPU() > spec.normalizeCPU();
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String toString() {
        return this.val + this.unit;
    }
}

