/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.config.k8s;

import com.qlangtech.tis.config.k8s.IReplicaScalaLog;
import com.qlangtech.tis.coredefine.module.action.Specification;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;

public class ReplicasSpec {
    public static final int maxCpuCoresLimit = 8;
    public static final int maxCpuCoresRequest = 4;
    private int replicaCount = 1;
    private boolean replicaScalable;
    private IReplicaScalaLog rcScalaLog;
    private Specification cpuRequest;
    private Specification cpuLimit;
    private Specification memoryRequest;
    private Specification memoryLimit;

    public static ReplicasSpec createDftReplicasSpec() {
        ReplicasSpec mysqlRcSpec = new ReplicasSpec();
        mysqlRcSpec.setReplicaCount(1);
        mysqlRcSpec.setMemoryLimit(Specification.parse("800M"));
        mysqlRcSpec.setMemoryRequest(Specification.parse("800M"));
        mysqlRcSpec.setCpuRequest(Specification.parse("250m"));
        mysqlRcSpec.setCpuLimit(Specification.parse("250m"));
        return mysqlRcSpec;
    }

    public static ReplicasSpec createDftPowerjobServerReplicasSpec() {
        ReplicasSpec mysqlRcSpec = new ReplicasSpec();
        mysqlRcSpec.setReplicaCount(1);
        mysqlRcSpec.setMemoryLimit(Specification.parse("1200M"));
        mysqlRcSpec.setMemoryRequest(Specification.parse("1000M"));
        mysqlRcSpec.setCpuRequest(Specification.parse("350m"));
        mysqlRcSpec.setCpuLimit(Specification.parse("500m"));
        return mysqlRcSpec;
    }

    public IReplicaScalaLog getRcScalaLog() {
        return this.rcScalaLog;
    }

    public void setRcScalaLog(IReplicaScalaLog rcScalaLog) {
        this.rcScalaLog = rcScalaLog;
    }

    public boolean isReplicaScalable() {
        return this.replicaScalable;
    }

    public void setReplicaScalable(boolean replicaScalable) {
        this.replicaScalable = replicaScalable;
    }

    public int getReplicaCount() {
        return this.replicaCount;
    }

    public void setReplicaCount(int replicaCount) {
        this.replicaCount = replicaCount;
    }

    public boolean isSpecificationsDiff(ReplicasSpec s) {
        return this.isNotEqula(this.getCpuLimit(), s.getCpuLimit()) || this.isNotEqula(this.getCpuRequest(), s.getCpuRequest()) || this.isNotEqula(this.getMemoryLimit(), s.getMemoryLimit()) || this.isNotEqula(this.getMemoryRequest(), s.getMemoryRequest());
    }

    private boolean isNotEqula(Specification s1, Specification s2) {
        return s1.getVal() != s2.getVal() || !StringUtils.equals((String)s1.getUnit(), (String)s2.getUnit());
    }

    public Specification getCpuRequest() {
        return this.cpuRequest;
    }

    public void setCpuRequest(Specification cpuRequest) {
        this.cpuRequest = cpuRequest;
    }

    public Specification getCpuLimit() {
        return this.cpuLimit;
    }

    public void setCpuLimit(Specification cpuLimit) {
        this.cpuLimit = cpuLimit;
    }

    public Specification getMemoryRequest() {
        return this.memoryRequest;
    }

    public void setMemoryRequest(Specification memoryRequest) {
        this.memoryRequest = memoryRequest;
    }

    public Specification getMemoryLimit() {
        return this.memoryLimit;
    }

    public void setMemoryLimit(Specification memoryLimit) {
        this.memoryLimit = memoryLimit;
    }

    public String toJavaMemorySpec(Optional<Integer> proportion) {
        return "-Xms" + (int)((double)this.getMemoryRequest().normalizeMemory(proportion) * 0.8) + "m -Xmx" + (int)((double)this.getMemoryLimit().normalizeMemory(proportion) * 0.8) + "m";
    }

    public static void main(String[] args) {
        System.out.println(83);
    }
}

