/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.assemble;

import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;

public enum FullbuildPhase {
    FullDump(1, "dump", "\u6570\u636e\u5bfc\u51fa"),
    JOIN(2, "join", "\u5bbd\u8868\u6784\u5efa"),
    BUILD(3, "indexBuild", "\u7d22\u5f15\u6784\u5efa"),
    IndexBackFlow(4, "indexBackflow", "\u7d22\u5f15\u56de\u6d41");

    private final int value;
    private final String name;
    private final String literal;

    public static String desc(Collection<FullbuildPhase> phaseSet) {
        return "[" + phaseSet.stream().map(r -> r.getName()).collect(Collectors.joining(",")) + "]";
    }

    public static FullbuildPhase getFirst(Collection<FullbuildPhase> phaseSet) {
        Optional<FullbuildPhase> min = phaseSet.stream().min((r1, r2) -> r1.value - r2.value);
        if (!min.isPresent()) {
            throw new IllegalStateException("phaseSet size shall not be 0");
        }
        return min.get();
    }

    public boolean bigThan(FullbuildPhase phase) {
        return this.value > phase.value;
    }

    private FullbuildPhase(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public static FullbuildPhase parse(String value) {
        if (FullbuildPhase.FullDump.name.equals(value)) {
            return FullDump;
        }
        if (FullbuildPhase.JOIN.name.equals(value)) {
            return JOIN;
        }
        if (FullbuildPhase.BUILD.name.equals(value)) {
            return BUILD;
        }
        if (FullbuildPhase.IndexBackFlow.name.equals(value)) {
            return IndexBackFlow;
        }
        throw new IllegalStateException("value " + value + " is not illegal");
    }

    public static FullbuildPhase parse(int value) {
        if (value == FullbuildPhase.FullDump.value) {
            return FullDump;
        }
        if (value == FullbuildPhase.JOIN.value) {
            return JOIN;
        }
        if (value == FullbuildPhase.BUILD.value) {
            return BUILD;
        }
        if (FullbuildPhase.IndexBackFlow.value == value) {
            return IndexBackFlow;
        }
        throw new IllegalStateException("value " + value + " is not illegal");
    }
}

