/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin.ds;

public enum JDBCTypes {
    CHAR(1, "CHAR"),
    LONGNVARCHAR(-16, "LONGNVARCHAR"),
    NVARCHAR(-9, "NVARCHAR"),
    REAL(7, "REAL"),
    CLOB(2005, "CLOB"),
    NUMERIC(2, "NUMERIC"),
    VARCHAR(12, "VARCHAR"),
    INTEGER(4, "INTEGER"),
    TINYINT(-6, "TINYINT"),
    OTHER(1111, "OTHER"),
    SMALLINT(5, "SMALLINT"),
    BIGINT(-5, "BIGINT"),
    FLOAT(6, "FLOAT"),
    DOUBLE(8, "DOUBLE"),
    DECIMAL(3, "DECIMAL"),
    DATE(91, "DATE"),
    TIME(92, "TIME"),
    TIMESTAMP(93, "TIMESTAMP"),
    BIT(-7, "BIT"),
    LONGVARCHAR(-1, "LONGVARCHAR"),
    BOOLEAN(16, "BOOLEAN"),
    BLOB(2004, "BLOB"),
    BINARY(-2, "BINARY"),
    LONGVARBINARY(-4, "LONGVARBINARY"),
    VARBINARY(-3, "VARBINARY");

    final int type;
    final String literia;

    public static JDBCTypes parse(int type) {
        return JDBCTypes.parse(type, true);
    }

    public static JDBCTypes parse(int type, boolean validateMatch) {
        for (JDBCTypes t : JDBCTypes.values()) {
            if (t.type != type) continue;
            return t;
        }
        if (validateMatch) {
            throw new IllegalArgumentException("illegal type value:" + type);
        }
        return null;
    }

    private JDBCTypes(int type, String literia) {
        this.type = type;
        this.literia = literia;
    }

    public int getType() {
        return this.type;
    }

    public String getLiteria() {
        return this.literia;
    }

    public String toString() {
        return "type=" + this.type + ", literia='" + this.literia + "'";
    }
}

