/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin.ds;

import java.util.Optional;

public interface IDBReservedKeys {
    default public Optional<String> getEscapeChar() {
        return Optional.empty();
    }

    default public String getEscapedEntity(String name) {
        return this.getEscapedEntity(Optional.empty(), name);
    }

    default public String getEscapedEntity(Optional<String> includeIn, String name) {
        Optional<String> escapeChar = this.getEscapeChar();
        String result = escapeChar.map(ec -> ec + name + ec).orElse(name);
        return includeIn.map(i -> i + result + i).orElse(result);
    }

    default public String removeEscapeChar(String entityName) {
        if (entityName == null) {
            throw new IllegalArgumentException("param entityName can not be null");
        }
        Optional<String> escape = this.getEscapeChar();
        if (escape.isPresent()) {
            return entityName.replace(escape.get(), "");
        }
        return entityName;
    }
}

