/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin.ds;

import com.qlangtech.tis.plugin.ds.DataType;
import com.qlangtech.tis.plugin.ds.JDBCTypes;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public enum DataXReaderColType {
    Long("long", new DataType(JDBCTypes.BIGINT)),
    INT("int", new DataType(JDBCTypes.INTEGER)),
    Double("double", new DataType(JDBCTypes.DOUBLE)),
    STRING("string", DataType.createVarChar(256)),
    Boolean("boolean", new DataType(JDBCTypes.BOOLEAN)),
    Date("date", new DataType(JDBCTypes.DATE)),
    Bytes("bytes", new DataType(JDBCTypes.BLOB));

    private final String literia;
    public final DataType dataType;

    private DataXReaderColType(String literia, DataType dataType) {
        this.literia = literia;
        this.dataType = dataType;
    }

    public static DataType parse(String literia) {
        literia = StringUtils.lowerCase((String)literia);
        for (DataXReaderColType t : DataXReaderColType.values()) {
            if (!literia.equals(t.literia)) continue;
            return t.dataType;
        }
        return null;
    }

    public String getLiteria() {
        return this.literia;
    }

    public String toString() {
        return this.literia;
    }

    public static String toDesc() {
        return Arrays.stream(DataXReaderColType.values()).map(t -> "'" + t.literia + "'").collect(Collectors.joining(","));
    }
}

