/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin.ds;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.qlangtech.tis.plugin.ds.ColSizeRange;
import com.qlangtech.tis.plugin.ds.DataType;
import com.qlangtech.tis.plugin.ds.DecimalRange;
import com.qlangtech.tis.plugin.ds.JDBCTypes;
import com.qlangtech.tis.plugin.ds.ViewContent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DataTypeMeta {
    public static final int DEFAULT_DECIMAL_PRECISION = 38;
    private final DataType _type;
    private final Optional<ColSizeRange> colSizeRange;
    private final Optional<DecimalRange> decimalRange;
    public static final List<DataTypeMeta> typeMetas = DataTypeMeta.createTypes(new DataTypeMeta(DataType.createVarChar(32), new ColSizeRange(1, 2000)), new DataTypeMeta(new DataType(JDBCTypes.INTEGER)), new DataTypeMeta(new DataType(JDBCTypes.TINYINT)), new DataTypeMeta(new DataType(JDBCTypes.SMALLINT)), new DataTypeMeta(new DataType(JDBCTypes.BIGINT)), new DataTypeMeta(new DataType(JDBCTypes.CHAR)), new DataTypeMeta(new DataType(JDBCTypes.FLOAT)), new DataTypeMeta(new DataType(JDBCTypes.DOUBLE)), new DataTypeMeta(new DataType(JDBCTypes.DECIMAL, 20).setDecimalDigits(0), new ColSizeRange(1, 46), new DecimalRange(1, 20)), new DataTypeMeta(new DataType(JDBCTypes.DATE)), new DataTypeMeta(new DataType(JDBCTypes.TIME)), new DataTypeMeta(new DataType(JDBCTypes.TIMESTAMP)), new DataTypeMeta(new DataType(JDBCTypes.BIT)), new DataTypeMeta(new DataType(JDBCTypes.LONGVARCHAR, Integer.MAX_VALUE)), new DataTypeMeta(new DataType(JDBCTypes.LONGNVARCHAR, Integer.MAX_VALUE)), new DataTypeMeta(new DataType(JDBCTypes.BOOLEAN)), new DataTypeMeta(new DataType(JDBCTypes.BLOB, 1000), new ColSizeRange(1, 2000)), new DataTypeMeta(new DataType(JDBCTypes.BINARY, 1000), new ColSizeRange(1, 2000)), new DataTypeMeta(new DataType(JDBCTypes.LONGVARBINARY, 1000), new ColSizeRange(1, 2000)), new DataTypeMeta(new DataType(JDBCTypes.VARBINARY, 1000), new ColSizeRange(1, 4000)));
    private static final Map<JDBCTypes, DataTypeMeta> typeMetasDic;

    public static int[] normalizeDecimalPrecisionAndScale(DataType type) {
        int precision = type.getColumnSize();
        Integer scale = type.getDecimalDigits();
        if (precision < 1 || precision > 38) {
            precision = 38;
        }
        return new int[]{precision, scale};
    }

    public static Map<String, Object> createViewBiz(IMultiItemsView multiItemsView, Object tabMapper) {
        List<String> elementGetKeys = Objects.requireNonNull(multiItemsView).getElementPropertyKeys();
        JSONObject biz = new JSONObject();
        biz.put("viewContentType", (Object)multiItemsView.getViewContent().getToken());
        if (elementGetKeys != null && !elementGetKeys.isEmpty()) {
            biz.put("elementKeys", elementGetKeys);
        }
        biz.put("tabMapper", Objects.requireNonNull(tabMapper, "tabMapper can not be null"));
        JSONArray types = new JSONArray();
        JSONObject type = null;
        JSONObject dt = null;
        DataType t = null;
        DataTypeMeta meta = null;
        JDBCTypes jdbcType = null;
        for (Map.Entry<JDBCTypes, DataTypeMeta> entry : DataTypeMeta.getTypeMetasDic().entrySet()) {
            DecimalRange decimalRange;
            meta = entry.getValue();
            jdbcType = entry.getKey();
            type = new JSONObject();
            type.put("containColSize", (Object)meta.isContainColSize());
            type.put("containDecimalRange", (Object)meta.isContainDecimalRange());
            dt = new JSONObject();
            t = meta.getType();
            dt.put("columnSize", (Object)t.getColumnSize());
            dt.put("decimalDigits", (Object)t.getDecimalDigits());
            dt.put("type", (Object)jdbcType.type);
            dt.put("typeDesc", (Object)t.getTypeDesc());
            dt.put("typeName", (Object)jdbcType.getLiteria());
            ColSizeRange colsSizeRange = meta.getColsSizeRange();
            if (colsSizeRange != null) {
                JSONObject range = new JSONObject();
                range.put("max", (Object)colsSizeRange.getMax());
                range.put("min", (Object)colsSizeRange.getMin());
                type.put("colsSizeRange", (Object)range);
            }
            if ((decimalRange = meta.getDecimalRange()) != null) {
                JSONObject range = new JSONObject();
                range.put("max", (Object)decimalRange.getMax());
                range.put("min", (Object)decimalRange.getMin());
                type.put("decimalRange", (Object)range);
            }
            type.put("type", (Object)dt);
            types.add((Object)type);
        }
        biz.put("colMetas", (Object)types);
        multiItemsView.appendExternalJsonProp(biz);
        return biz;
    }

    private static List<DataTypeMeta> createTypes(DataTypeMeta ... metas) {
        ArrayList<DataTypeMeta> result = new ArrayList<DataTypeMeta>();
        for (DataTypeMeta meta : metas) {
            result.add(meta);
        }
        return Collections.unmodifiableList(result);
    }

    public static Map<JDBCTypes, DataTypeMeta> getTypeMetasDic() {
        return typeMetasDic;
    }

    public static DataTypeMeta getDataTypeMeta(JDBCTypes type) {
        return Objects.requireNonNull(typeMetasDic.get((Object)type), "type:" + type + " relevant " + DataTypeMeta.class.getSimpleName() + " can not be null");
    }

    public DataTypeMeta(DataType type) {
        this(type, Optional.empty(), Optional.empty());
    }

    public DataTypeMeta(DataType type, ColSizeRange colSizeRange) {
        this(type, Optional.of(colSizeRange), Optional.empty());
    }

    public DataTypeMeta(DataType type, ColSizeRange colSizeRange, DecimalRange decimalRange) {
        this(type, Optional.of(colSizeRange), Optional.of(decimalRange));
    }

    private DataTypeMeta(DataType type, Optional<ColSizeRange> colSizeRange, Optional<DecimalRange> decimalRange) {
        this._type = Objects.requireNonNull(type, "dataType can not be null");
        this.colSizeRange = colSizeRange;
        this.decimalRange = decimalRange;
    }

    public DataType getType() {
        return Objects.requireNonNull(this._type, "type can not be null");
    }

    public boolean isContainColSize() {
        return this.colSizeRange.isPresent();
    }

    public ColSizeRange getColsSizeRange() {
        return this.colSizeRange.orElse(null);
    }

    public boolean isContainDecimalRange() {
        return this.decimalRange.isPresent();
    }

    public DecimalRange getDecimalRange() {
        return this.decimalRange.orElse(null);
    }

    static {
        HashMap<JDBCTypes, DataTypeMeta> dic = new HashMap<JDBCTypes, DataTypeMeta>();
        for (DataTypeMeta type : typeMetas) {
            dic.put(type._type.getJdbcType(), type);
        }
        dic.put(JDBCTypes.OTHER, (DataTypeMeta)dic.get((Object)JDBCTypes.VARCHAR));
        dic.put(JDBCTypes.REAL, (DataTypeMeta)dic.get((Object)JDBCTypes.FLOAT));
        dic.put(JDBCTypes.NUMERIC, (DataTypeMeta)dic.get((Object)JDBCTypes.DECIMAL));
        typeMetasDic = Collections.unmodifiableMap(dic);
    }

    public static interface IMultiItemsView {
        public static IMultiItemsView unknow() {
            return new IMultiItemsView(){

                @Override
                public List<String> getElementPropertyKeys() {
                    return Collections.emptyList();
                }

                @Override
                public ViewContent getViewContent() {
                    return ViewContent.Unknow;
                }
            };
        }

        public List<String> getElementPropertyKeys();

        public ViewContent getViewContent();

        default public void appendExternalJsonProp(JSONObject biz) {
        }
    }
}

