/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin.ds;

import com.alibaba.fastjson.annotation.JSONField;
import com.qlangtech.tis.plugin.ds.DataTypeMeta;
import com.qlangtech.tis.plugin.ds.DataXReaderColType;
import com.qlangtech.tis.plugin.ds.JDBCTypes;
import java.io.Serializable;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class DataType
implements Serializable,
Cloneable {
    public static final String KEY_UNSIGNED = "UNSIGNED";
    private final JDBCTypes type;
    public final String typeName;
    private final int columnSize;
    private final boolean unsigned;
    private Integer decimalDigits = -1;
    private static final Pattern patternDataType = Pattern.compile("(-?\\d+),(-?\\d+),(-?\\d*)");

    public static DataType createVarChar(int size) {
        if (size < 1) {
            throw new IllegalArgumentException("illegal param size can not small than 1");
        }
        return new DataType(JDBCTypes.VARCHAR, size);
    }

    public DataType clone() throws CloneNotSupportedException {
        DataType result = new DataType(this.type, this.typeName, this.columnSize, this.unsigned);
        result.setDecimalDigits(this.getDecimalDigits());
        return result;
    }

    public final int getType() {
        return this.type.getType();
    }

    @JSONField(serialize=false)
    public final JDBCTypes getJdbcType() {
        return this.type;
    }

    public DataType(JDBCTypes type) {
        this(type, -1);
    }

    public static DataType getType(JDBCTypes jdbcType) {
        return DataTypeMeta.getDataTypeMeta(jdbcType).getType();
    }

    public DataType(JDBCTypes type, int columnSize) {
        this(type, type.getLiteria(), columnSize, false);
    }

    public DataType(JDBCTypes type, String typeName, int columnSize, boolean unsigned) {
        this.type = type;
        this.typeName = typeName;
        this.columnSize = columnSize;
        this.unsigned = unsigned;
    }

    public static DataType create(Integer type, String typeName, Integer columnSize) {
        return new DataType(JDBCTypes.parse(Objects.requireNonNull(type, "param type can not be null")), typeName, Objects.requireNonNull(columnSize, "param columnSize can not be null"), StringUtils.containsIgnoreCase((CharSequence)typeName, (CharSequence)KEY_UNSIGNED));
    }

    @JSONField(serialize=false)
    public boolean isUnsigned() {
        return this.unsigned;
    }

    @JSONField(serialize=false)
    public String getUnsignedToken() {
        if (this.isUnsigned()) {
            return KEY_UNSIGNED;
        }
        return "";
    }

    @JSONField(serialize=false)
    public DataXReaderColType getCollapse() {
        switch (this.type) {
            case INTEGER: 
            case TINYINT: 
            case SMALLINT: 
            case BIGINT: {
                return DataXReaderColType.Long;
            }
            case FLOAT: 
            case DOUBLE: 
            case REAL: 
            case DECIMAL: 
            case NUMERIC: {
                return DataXReaderColType.Double;
            }
            case DATE: 
            case TIME: 
            case TIMESTAMP: {
                return DataXReaderColType.Date;
            }
            case BIT: 
            case BOOLEAN: {
                return DataXReaderColType.Boolean;
            }
            case BLOB: 
            case BINARY: 
            case LONGVARBINARY: 
            case VARBINARY: {
                return DataXReaderColType.Bytes;
            }
        }
        return DataXReaderColType.STRING;
    }

    public String getTypeDesc() {
        String type = this.accept(new TypeVisitor<String>(){

            @Override
            public String intType(DataType type) {
                return "int";
            }

            @Override
            public String bigInt(DataType type) {
                return "bigint";
            }

            @Override
            public String floatType(DataType type) {
                return "float";
            }

            @Override
            public String doubleType(DataType type) {
                return "double";
            }

            @Override
            public String decimalType(DataType type) {
                return "decimal(" + type.getColumnSize() + "," + type.getDecimalDigits() + ")";
            }

            @Override
            public String dateType(DataType type) {
                return "date";
            }

            @Override
            public String timeType(DataType type) {
                return "time";
            }

            @Override
            public String timestampType(DataType type) {
                return "timestamp";
            }

            @Override
            public String bitType(DataType type) {
                return "bit";
            }

            @Override
            public String blobType(DataType type) {
                return "blob(" + type.getColumnSize() + ")";
            }

            @Override
            public String varcharType(DataType type) {
                return "varchar(" + type.getColumnSize() + ")";
            }

            @Override
            public String tinyIntType(DataType dataType) {
                return "tinyint";
            }

            @Override
            public String smallIntType(DataType dataType) {
                return "smallint";
            }

            @Override
            public String boolType(DataType dataType) {
                return "bool";
            }
        });
        return this.isUnsigned() ? StringUtils.lowerCase((String)KEY_UNSIGNED) + " " + type : type;
    }

    public <T> T accept(TypeVisitor<T> visitor) {
        switch (this.type) {
            case INTEGER: {
                return visitor.intType(this);
            }
            case TINYINT: {
                return visitor.tinyIntType(this);
            }
            case SMALLINT: {
                return visitor.smallIntType(this);
            }
            case BIGINT: {
                return visitor.bigInt(this);
            }
            case FLOAT: 
            case REAL: {
                return visitor.floatType(this);
            }
            case DOUBLE: {
                return visitor.doubleType(this);
            }
            case DECIMAL: 
            case NUMERIC: {
                return visitor.decimalType(this);
            }
            case DATE: {
                return visitor.dateType(this);
            }
            case TIME: {
                return visitor.timeType(this);
            }
            case TIMESTAMP: {
                return visitor.timestampType(this);
            }
            case BIT: {
                return visitor.bitType(this);
            }
            case BOOLEAN: {
                return visitor.boolType(this);
            }
            case BINARY: {
                if ("boolean".equalsIgnoreCase(this.typeName)) {
                    return visitor.boolType(this);
                }
            }
            case BLOB: 
            case LONGVARBINARY: 
            case VARBINARY: {
                return visitor.blobType(this);
            }
        }
        return visitor.varcharType(this);
    }

    public Integer getDecimalDigits() {
        DataTypeMeta typeMeta;
        if (this.decimalDigits < 0 && (typeMeta = Objects.requireNonNull(DataTypeMeta.getDataTypeMeta(this.type), "type:" + this.type + ", relevant type meta can not be null")).isContainDecimalRange()) {
            this.decimalDigits = typeMeta.getType().decimalDigits;
        }
        return this.decimalDigits == null ? 0 : this.decimalDigits;
    }

    public DataType setDecimalDigits(Integer decimalDigits) {
        this.decimalDigits = decimalDigits;
        return this;
    }

    @JSONField(serialize=false)
    public String getS() {
        return this.type.type + "," + this.getColumnSize() + "," + (Serializable)(this.decimalDigits != null ? this.decimalDigits : "");
    }

    public static DataType ds(String ser) {
        Matcher matcher = patternDataType.matcher(ser);
        if (!matcher.matches()) {
            throw new IllegalStateException("val is illegal:" + ser);
        }
        DataType type = new DataType(JDBCTypes.parse(Integer.parseInt(matcher.group(1))), Integer.parseInt(matcher.group(2)));
        String d = matcher.group(3);
        if (StringUtils.isNotEmpty((CharSequence)d)) {
            type.decimalDigits = Integer.parseInt(d);
        }
        return type;
    }

    public String toString() {
        return this.getS();
    }

    public int getColumnSize() {
        DataTypeMeta typeMeta;
        if (this.columnSize < 0 && (typeMeta = Objects.requireNonNull(DataTypeMeta.getDataTypeMeta(this.type), "type:" + this.type + " relevant type meta can not be null")).isContainColSize()) {
            return typeMeta.getType().columnSize;
        }
        return this.columnSize;
    }

    public static class DefaultTypeVisitor<T>
    implements TypeVisitor<T> {
        @Override
        public T bigInt(DataType type) {
            return null;
        }

        @Override
        public T doubleType(DataType type) {
            return null;
        }

        @Override
        public T dateType(DataType type) {
            return null;
        }

        @Override
        public T timestampType(DataType type) {
            return null;
        }

        @Override
        public T bitType(DataType type) {
            return null;
        }

        @Override
        public T blobType(DataType type) {
            return null;
        }

        @Override
        public T varcharType(DataType type) {
            return null;
        }

        @Override
        public T intType(DataType type) {
            return null;
        }

        @Override
        public T floatType(DataType type) {
            return null;
        }

        @Override
        public T decimalType(DataType type) {
            return null;
        }

        @Override
        public T timeType(DataType type) {
            return null;
        }

        @Override
        public T tinyIntType(DataType dataType) {
            return null;
        }

        @Override
        public T smallIntType(DataType dataType) {
            return null;
        }

        @Override
        public T boolType(DataType dataType) {
            return null;
        }
    }

    public static interface PartialTypeVisitor<T>
    extends TypeVisitor<T> {
        @Override
        default public T intType(DataType type) {
            return this.bigInt(type);
        }

        @Override
        public T bigInt(DataType var1);

        @Override
        default public T floatType(DataType type) {
            return this.doubleType(type);
        }

        @Override
        public T doubleType(DataType var1);

        @Override
        default public T decimalType(DataType type) {
            return this.doubleType(type);
        }

        @Override
        public T dateType(DataType var1);

        @Override
        default public T timeType(DataType type) {
            return this.timestampType(type);
        }

        @Override
        public T timestampType(DataType var1);

        @Override
        public T bitType(DataType var1);

        @Override
        public T blobType(DataType var1);

        @Override
        public T varcharType(DataType var1);

        @Override
        default public T tinyIntType(DataType dataType) {
            return this.intType(dataType);
        }

        @Override
        default public T smallIntType(DataType dataType) {
            return this.intType(dataType);
        }

        @Override
        default public T boolType(DataType dataType) {
            return this.bitType(dataType);
        }
    }

    public static interface TypeVisitor<T> {
        public T intType(DataType var1);

        public T bigInt(DataType var1);

        public T floatType(DataType var1);

        public T doubleType(DataType var1);

        public T decimalType(DataType var1);

        public T dateType(DataType var1);

        public T timeType(DataType var1);

        public T timestampType(DataType var1);

        public T bitType(DataType var1);

        public T blobType(DataType var1);

        public T varcharType(DataType var1);

        public T tinyIntType(DataType var1);

        public T smallIntType(DataType var1);

        public T boolType(DataType var1);
    }
}

