/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.plugin.ds;

import com.qlangtech.tis.plugin.ds.DataType;
import com.qlangtech.tis.plugin.ds.JDBCTypes;
import com.qlangtech.tis.plugin.ds.RunningContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public abstract class ContextParamConfig {
    public static final String CONTEXT_BINDED_KEY_PREFIX = "$";
    private final String keyName;
    public static final String KEY_DB_CONTEXT_PARAM_NAME = "dbName";

    public static Map<String, ContextParamConfig> defaultContextParams() {
        return ContextParamConfig.defaultContextParams(param -> true);
    }

    public static Map<String, ContextParamConfig> defaultContextParams(Predicate<ContextParamConfig> paramPredicate) {
        ContextParamConfig dbName = new ContextParamConfig(KEY_DB_CONTEXT_PARAM_NAME){

            @Override
            public ContextParamValGetter<RunningContext> valGetter() {
                return new DbNameContextParamValGetter();
            }

            @Override
            public DataType getDataType() {
                return DataType.createVarChar(50);
            }
        };
        ContextParamConfig sysTimestamp = new ContextParamConfig("timestamp"){

            @Override
            public ContextParamValGetter<RunningContext> valGetter() {
                return new SystemTimeStampContextParamValGetter();
            }

            @Override
            public DataType getDataType() {
                return DataType.getType(JDBCTypes.TIMESTAMP);
            }
        };
        ContextParamConfig tableName = new ContextParamConfig("tableName"){

            @Override
            public ContextParamValGetter<RunningContext> valGetter() {
                return new TableNameContextParamValGetter();
            }

            @Override
            public DataType getDataType() {
                return DataType.createVarChar(50);
            }
        };
        ArrayList<ContextParamConfig> contextParams = new ArrayList<ContextParamConfig>();
        contextParams.add(dbName);
        contextParams.add(tableName);
        contextParams.add(sysTimestamp);
        return contextParams.stream().filter(paramPredicate).collect(Collectors.toMap(cfg -> cfg.getKeyName(), cfg -> cfg));
    }

    public ContextParamConfig(String keyName) {
        if (StringUtils.startsWith((CharSequence)keyName, (CharSequence)CONTEXT_BINDED_KEY_PREFIX)) {
            throw new IllegalArgumentException("param keyName:" + keyName + " can not start with:$");
        }
        this.keyName = CONTEXT_BINDED_KEY_PREFIX + keyName;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public abstract ContextParamValGetter valGetter();

    public abstract DataType getDataType();

    public static interface ContextParamValGetter<CONTEXT extends RunningContext>
    extends Function<CONTEXT, Object>,
    Serializable {
    }

    public static class TableNameContextParamValGetter
    implements ContextParamValGetter<RunningContext> {
        @Override
        public Object apply(RunningContext runningContext) {
            return runningContext.getTable();
        }
    }

    public static class SystemTimeStampContextParamValGetter
    implements ContextParamValGetter<RunningContext> {
        @Override
        public Object apply(RunningContext runningContext) {
            return System.currentTimeMillis();
        }
    }

    public static class DbNameContextParamValGetter
    implements ContextParamValGetter<RunningContext> {
        @Override
        public Object apply(RunningContext runningContext) {
            return runningContext.getDbName();
        }
    }
}

