/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.datax;

import com.qlangtech.tis.datax.ITimeFormat;
import java.time.Clock;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import org.apache.commons.lang3.StringUtils;

public enum TimeFormat implements ITimeFormat
{
    yyyyMMdd_HH_mm_ss(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")),
    yyyyMMddHHmmss(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")),
    yyyyMMdd(DateTimeFormatter.ofPattern("yyyyMMdd")),
    yyyy_MM_dd(DateTimeFormatter.ofPattern("yyyy-MM-dd"));

    public static final ZoneId sysZoneId;
    public final DateTimeFormatter timeFormatter;
    public static Long timestampForTest;

    private TimeFormat(DateTimeFormatter timeFormatter) {
        this.timeFormatter = timeFormatter;
    }

    public static long getCurrentTimeStamp() {
        if (timestampForTest != null) {
            return timestampForTest;
        }
        return Clock.system(sysZoneId).millis();
    }

    public String format(long epochMilli) {
        return this.ofInstant(epochMilli).format(this.timeFormatter);
    }

    public LocalDateTime ofInstant(long epochMilli) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(epochMilli), sysZoneId);
    }

    public static TimeFormat parse(String token) {
        for (TimeFormat f : TimeFormat.values()) {
            if (!StringUtils.endsWithIgnoreCase((CharSequence)f.name(), (CharSequence)token)) continue;
            return f;
        }
        throw new IllegalStateException("illegal token:" + token);
    }

    public static void main(String[] args) {
        System.out.println(yyyyMMddHHmmss.format(1709001500699L));
    }

    static {
        sysZoneId = ZoneOffset.systemDefault();
    }
}

