/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.datax;

public enum StoreResourceType {
    DataBase("db", false, ""),
    DataApp("ap", false, "DataxProcessor"),
    DataFlow("df", false, "WorkflowProcessor");

    public static final String KEY_STORE_RESOURCE_TYPE = "storeResType";
    public static final String KEY_PROCESS_MODEL = "processModel";
    public static final String DATAX_NAME = "dataxName";
    public static final String DATAX_DB_NAME = "dataxDB";
    private final String type;
    public final boolean useMetaCfgDir;
    public final String pluginDescName;

    public static StoreResourceType parse(boolean isDB) {
        return isDB ? DataBase : DataApp;
    }

    public static StoreResourceType parse(String type) {
        StoreResourceType[] types;
        for (StoreResourceType t : types = StoreResourceType.values()) {
            if (!t.type.equals(type)) continue;
            return t;
        }
        throw new IllegalStateException("illegal type:" + type);
    }

    public static String getPipeParma(StoreResourceType resourceType, String appname) {
        switch (resourceType) {
            case DataApp: 
            case DataFlow: {
                return "dataxName_" + appname;
            }
            case DataBase: {
                return "dataxDB_" + appname;
            }
        }
        throw new IllegalStateException("illegal resType:" + resourceType);
    }

    public String getType() {
        return this.type;
    }

    private StoreResourceType(String type, boolean useMetaCfgDir, String pluginDescName) {
        this.type = type;
        this.useMetaCfgDir = useMetaCfgDir;
        this.pluginDescName = pluginDescName;
    }
}

