/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.datax;

import com.qlangtech.tis.datax.StoreResourceType;
import java.io.Serializable;
import java.util.Objects;

public class DataXName
implements Serializable {
    private final String pipelineName;
    private final StoreResourceType type;

    public static DataXName createDataXPipeline(String pipelineName) {
        return new DataXName(pipelineName, StoreResourceType.DataApp);
    }

    public boolean isDataAppType() {
        return this.getType() == StoreResourceType.DataApp;
    }

    public boolean isDataFlowType() {
        return this.getType() == StoreResourceType.DataFlow;
    }

    public StoreResourceType assetCheckDataAppType() {
        return this.assetCheckType(StoreResourceType.DataApp);
    }

    public StoreResourceType assetCheckType(StoreResourceType resType) {
        if (this.getType() != resType) {
            throw new IllegalStateException("dataXName type must be :" + resType + " but is :" + this.getType());
        }
        return this.getType();
    }

    public DataXName(String pipelineName, StoreResourceType type) {
        this.pipelineName = pipelineName;
        this.type = Objects.requireNonNull(type, "target type can not be null");
    }

    public String getPipelineName() {
        return this.pipelineName;
    }

    public StoreResourceType getType() {
        return this.type;
    }

    public String toString() {
        return this.pipelineName;
    }
}

