/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.plugin.writer.hdfswriter;

import com.alibaba.datax.common.util.Configuration;
import com.qlangtech.tis.plugin.ds.DataType;
import com.qlangtech.tis.plugin.ds.IColMetaGetter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class HdfsColMeta
implements Serializable,
IColMetaGetter {
    public static final String KEY_COLUMN = "column";
    public static final String KEY_NAME = "name";
    public static final String KEY_TYPE = "type";
    public static final String KEY_NULLABLE = "nullable";
    public static final String KEY_PK = "pk";
    public final String colName;
    public final boolean nullable;
    public final DataType type;
    public final CsvType csvType;
    public final boolean pk;

    public static <T extends IColMetaGetter> List<T> getColsMeta(Configuration config) {
        Objects.requireNonNull(config, "param config can not be null");
        ArrayList<HdfsColMeta> result = new ArrayList<HdfsColMeta>();
        List<Configuration> columns = config.getListConfiguration(KEY_COLUMN);
        DataType hiveType = null;
        HdfsColMeta meta = null;
        for (Configuration cfg : columns) {
            hiveType = DataType.ds(cfg.getString(KEY_TYPE));
            meta = new HdfsColMeta(cfg.getString(KEY_NAME), cfg.getBool(KEY_NULLABLE, true), cfg.getBool(KEY_PK, false), hiveType);
            result.add(meta);
        }
        return result;
    }

    public HdfsColMeta(String colName, Boolean nullable, Boolean pk, DataType dataType) {
        this.colName = colName;
        if (nullable == null) {
            throw new IllegalStateException("config of col:" + colName + " relevant nullable prop can not be null");
        }
        this.nullable = nullable;
        this.type = dataType;
        this.csvType = HdfsColMeta.parseCsvType(dataType);
        this.pk = pk;
    }

    @Override
    public boolean isPk() {
        return this.pk;
    }

    @Override
    public DataType getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.colName;
    }

    private static CsvType parseCsvType(DataType dataType) {
        switch (dataType.getCollapse()) {
            case STRING: 
            case Date: 
            case Bytes: {
                return CsvType.STRING;
            }
            case Long: 
            case INT: 
            case Double: {
                return CsvType.NUMBER;
            }
            case Boolean: {
                return CsvType.BOOLEAN;
            }
        }
        throw new IllegalStateException("illegal type:" + dataType.getCollapse());
    }

    public String toString() {
        return "col='" + this.colName + "', type=" + this.type + ", pk=" + this.pk;
    }

    public static enum CsvType {
        STRING,
        NUMBER,
        BOOLEAN;

    }
}

