/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.common.util;

import com.alibaba.datax.common.util.Configuration;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TimeZone;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageSource {
    private static final Logger LOG = LoggerFactory.getLogger(MessageSource.class);
    private static Map<String, ResourceBundle> resourceBundleCache = new HashMap<String, ResourceBundle>();
    public static Locale locale = null;
    public static TimeZone timeZone = null;
    private ResourceBundle resourceBundle = null;

    private MessageSource(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public static MessageSource loadResourceBundle(ClassLoader classLoader, String baseName) {
        return MessageSource.loadResourceBundle(classLoader, baseName, locale, timeZone);
    }

    public static <T> MessageSource loadResourceBundle(Class<T> clazz) {
        return MessageSource.loadResourceBundle(clazz.getClassLoader(), clazz.getPackage().getName());
    }

    public static <T> MessageSource loadResourceBundle(Class<T> clazz, Locale locale, TimeZone timeZone) {
        return MessageSource.loadResourceBundle(clazz.getClassLoader(), clazz.getPackage().getName(), locale, timeZone);
    }

    public static MessageSource loadResourceBundle(String baseName, Locale locale, TimeZone timeZone) {
        ClassLoader clazzLoader = Thread.currentThread().getContextClassLoader();
        return MessageSource.loadResourceBundle(clazzLoader, baseName, locale, timeZone);
    }

    public static MessageSource loadResourceBundle(ClassLoader clazzLoader, String baseName, Locale locale, TimeZone timeZone) {
        if (clazzLoader == null) {
            throw new IllegalArgumentException("argument classloader can not be null");
        }
        ResourceBundle resourceBundle = null;
        if (null == locale) {
            locale = LocaleUtils.toLocale((String)"en_US");
        }
        if (null == timeZone) {
            timeZone = TimeZone.getDefault();
        }
        String resourceBaseName = String.format("%s.LocalStrings", baseName);
        LOG.debug("initEnvironment MessageSource.locale[{}], MessageSource.timeZone[{}]", (Object)MessageSource.locale, (Object)MessageSource.timeZone);
        LOG.debug("loadResourceBundle with locale[{}], timeZone[{}], baseName[{}]", new Object[]{locale, timeZone, resourceBaseName});
        if (!resourceBundleCache.containsKey(resourceBaseName)) {
            LOG.debug("loadResourceBundle classLoader:{}", (Object)clazzLoader);
            resourceBundle = ResourceBundle.getBundle(resourceBaseName, locale, clazzLoader);
            resourceBundleCache.put(resourceBaseName, resourceBundle);
        } else {
            resourceBundle = resourceBundleCache.get(resourceBaseName);
        }
        return new MessageSource(resourceBundle);
    }

    public static <T> boolean unloadResourceBundle(Class<T> clazz) {
        String baseName = clazz.getPackage().getName();
        String resourceBaseName = String.format("%s.LocalStrings", baseName);
        if (!resourceBundleCache.containsKey(resourceBaseName)) {
            return false;
        }
        resourceBundleCache.remove(resourceBaseName);
        return true;
    }

    public static <T> MessageSource reloadResourceBundle(Class<T> clazz) {
        MessageSource.unloadResourceBundle(clazz);
        return MessageSource.loadResourceBundle(clazz);
    }

    public static void setEnvironment(Locale locale, TimeZone timeZone) {
        Locale.setDefault(locale);
        TimeZone.setDefault(timeZone);
        MessageSource.locale = locale;
        MessageSource.timeZone = timeZone;
        LOG.info("use Locale: {} timeZone: {}", (Object)locale, (Object)timeZone);
    }

    public static void init(Configuration configuration) {
        Locale locale2Set = Locale.getDefault();
        String localeStr = configuration.getString("common.column.locale", "zh_CN");
        if (StringUtils.isNotBlank((CharSequence)localeStr)) {
            try {
                locale2Set = LocaleUtils.toLocale((String)localeStr);
            }
            catch (Exception e) {
                LOG.warn("ignored locale parse exception: {}", (Object)e.getMessage());
            }
        }
        TimeZone timeZone2Set = TimeZone.getDefault();
        String timeZoneStr = configuration.getString("common.column.timeZone");
        if (StringUtils.isNotBlank((CharSequence)timeZoneStr)) {
            try {
                timeZone2Set = TimeZone.getTimeZone(timeZoneStr);
            }
            catch (Exception e) {
                LOG.warn("ignored timezone parse exception: {}", (Object)e.getMessage());
            }
        }
        LOG.info("JVM TimeZone: {}, Locale: {}", (Object)timeZone2Set.getID(), (Object)locale2Set);
        MessageSource.setEnvironment(locale2Set, timeZone2Set);
    }

    public static void clearCache() {
        resourceBundleCache.clear();
    }

    public String message(String code) {
        return this.messageWithDefaultMessage(code, null);
    }

    public String message(String code, String args1) {
        return this.messageWithDefaultMessage(code, null, args1);
    }

    public String message(String code, String args1, String args2) {
        return this.messageWithDefaultMessage(code, null, args1, args2);
    }

    public String message(String code, String args1, String args2, String args3) {
        return this.messageWithDefaultMessage(code, null, args1, args2, args3);
    }

    public String message(String code, Object ... args) {
        return this.messageWithDefaultMessage(code, null, args);
    }

    public String messageWithDefaultMessage(String code, String defaultMessage) {
        return this.messageWithDefaultMessage(code, defaultMessage, new Object[0]);
    }

    public String messageWithDefaultMessage(String code, String defaultMessage, Object ... args) {
        String messageStr = null;
        try {
            messageStr = this.resourceBundle.getString(code);
        }
        catch (MissingResourceException e) {
            messageStr = defaultMessage;
        }
        if (null != messageStr && null != args && args.length > 0) {
            return MessageFormat.format(messageStr, args);
        }
        return messageStr;
    }
}

