/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.common.util;

import com.alibaba.datax.common.exception.CommonErrorCode;
import com.alibaba.datax.common.exception.DataXException;
import com.alibaba.datax.common.spi.ErrorCode;
import com.alibaba.datax.common.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.CharUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class Configuration {
    private Set<String> secretKeyPathSet = new HashSet<String>();
    private Object root = null;

    public static Configuration newDefault() {
        return Configuration.from("{}");
    }

    public static Configuration from(String json) {
        json = StrUtil.replaceVariable(json);
        Configuration.checkJSON(json);
        try {
            return new Configuration(json);
        }
        catch (Exception e) {
            throw DataXException.asDataXException((ErrorCode)CommonErrorCode.CONFIG_ERROR, e);
        }
    }

    public static Configuration from(File file) {
        try {
            return Configuration.from(IOUtils.toString((InputStream)new FileInputStream(file)));
        }
        catch (FileNotFoundException e) {
            throw DataXException.asDataXException((ErrorCode)CommonErrorCode.CONFIG_ERROR, String.format("\u914d\u7f6e\u4fe1\u606f\u9519\u8bef\uff0c\u60a8\u63d0\u4f9b\u7684\u914d\u7f6e\u6587\u4ef6[%s]\u4e0d\u5b58\u5728. \u8bf7\u68c0\u67e5\u60a8\u7684\u914d\u7f6e\u6587\u4ef6.", file.getAbsolutePath()));
        }
        catch (IOException e) {
            throw DataXException.asDataXException((ErrorCode)CommonErrorCode.CONFIG_ERROR, String.format("\u914d\u7f6e\u4fe1\u606f\u9519\u8bef. \u60a8\u63d0\u4f9b\u914d\u7f6e\u6587\u4ef6[%s]\u8bfb\u53d6\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0: %s. \u8bf7\u68c0\u67e5\u60a8\u7684\u914d\u7f6e\u6587\u4ef6\u7684\u6743\u9650\u8bbe\u7f6e.", file.getAbsolutePath(), e));
        }
    }

    public static Configuration from(InputStream is) {
        try {
            return Configuration.from(IOUtils.toString((InputStream)is));
        }
        catch (IOException e) {
            throw DataXException.asDataXException((ErrorCode)CommonErrorCode.CONFIG_ERROR, String.format("\u8bf7\u68c0\u67e5\u60a8\u7684\u914d\u7f6e\u6587\u4ef6. \u60a8\u63d0\u4f9b\u7684\u914d\u7f6e\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25\uff0c\u9519\u8bef\u539f\u56e0: %s. \u8bf7\u68c0\u67e5\u60a8\u7684\u914d\u7f6e\u6587\u4ef6\u7684\u6743\u9650\u8bbe\u7f6e.", e));
        }
    }

    public static Configuration from(Map<String, Object> object) {
        return Configuration.from(Configuration.toJSONString(object));
    }

    public static Configuration from(List<Object> object) {
        return Configuration.from(Configuration.toJSONString(object));
    }

    public String getNecessaryValue(String key, ErrorCode errorCode) {
        String value = this.getString(key, null);
        if (StringUtils.isBlank((CharSequence)value)) {
            throw DataXException.asDataXException(errorCode, String.format("\u60a8\u63d0\u4f9b\u914d\u7f6e\u6587\u4ef6\u6709\u8bef\uff0c[%s]\u662f\u5fc5\u586b\u53c2\u6570\uff0c\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u6216\u8005\u7559\u767d .", key));
        }
        return value;
    }

    public String getUnnecessaryValue(String key, String defaultValue, ErrorCode errorCode) {
        String value = this.getString(key, defaultValue);
        if (StringUtils.isBlank((CharSequence)value)) {
            value = defaultValue;
        }
        return value;
    }

    public Boolean getNecessaryBool(String key, ErrorCode errorCode) {
        Boolean value = this.getBool(key);
        if (value == null) {
            throw DataXException.asDataXException(errorCode, String.format("\u60a8\u63d0\u4f9b\u914d\u7f6e\u6587\u4ef6\u6709\u8bef\uff0c[%s]\u662f\u5fc5\u586b\u53c2\u6570\uff0c\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u6216\u8005\u7559\u767d .", key));
        }
        return value;
    }

    public Object get(String path) {
        this.checkPath(path);
        try {
            return this.findObject(path);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Configuration getConfiguration(String path) {
        Object object = this.get(path);
        if (null == object) {
            return null;
        }
        return Configuration.from(Configuration.toJSONString(object));
    }

    public String getString(String path) {
        Object string = this.get(path);
        if (null == string) {
            return null;
        }
        return String.valueOf(string);
    }

    public String getString(String path, String defaultValue) {
        String result = this.getString(path);
        if (null == result) {
            return defaultValue;
        }
        return result;
    }

    public Character getChar(String path) {
        String result = this.getString(path);
        if (null == result) {
            return null;
        }
        try {
            return Character.valueOf(CharUtils.toChar((String)result));
        }
        catch (Exception e) {
            throw DataXException.asDataXException((ErrorCode)CommonErrorCode.CONFIG_ERROR, String.format("\u4efb\u52a1\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6\u51fa\u9519. \u56e0\u4e3a\u914d\u7f6e\u6587\u4ef6\u8def\u5f84[%s] \u503c\u975e\u6cd5\uff0c\u671f\u671b\u662f\u5b57\u7b26\u7c7b\u578b: %s. \u8bf7\u68c0\u67e5\u60a8\u7684\u914d\u7f6e\u5e76\u4f5c\u51fa\u4fee\u6539.", path, e.getMessage()));
        }
    }

    public Character getChar(String path, char defaultValue) {
        Character result = this.getChar(path);
        if (null == result) {
            return Character.valueOf(defaultValue);
        }
        return result;
    }

    public Boolean getBool(String path) {
        String result = this.getString(path);
        if (null == result) {
            return null;
        }
        if ("true".equalsIgnoreCase(result)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(result)) {
            return Boolean.FALSE;
        }
        throw DataXException.asDataXException((ErrorCode)CommonErrorCode.CONFIG_ERROR, String.format("\u60a8\u63d0\u4f9b\u7684\u914d\u7f6e\u4fe1\u606f\u6709\u8bef\uff0c\u56e0\u4e3a\u4ece[%s]\u83b7\u53d6\u7684\u503c[%s]\u65e0\u6cd5\u8f6c\u6362\u4e3abool\u7c7b\u578b. \u8bf7\u68c0\u67e5\u6e90\u8868\u7684\u914d\u7f6e\u5e76\u4e14\u505a\u51fa\u76f8\u5e94\u7684\u4fee\u6539.", path, result));
    }

    public Boolean getBool(String path, boolean defaultValue) {
        Boolean result = this.getBool(path);
        if (null == result) {
            return defaultValue;
        }
        return result;
    }

    public Integer getInt(String path) {
        String result = this.getString(path);
        if (null == result) {
            return null;
        }
        try {
            return Integer.valueOf(result);
        }
        catch (Exception e) {
            throw DataXException.asDataXException((ErrorCode)CommonErrorCode.CONFIG_ERROR, String.format("\u4efb\u52a1\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6\u51fa\u9519. \u914d\u7f6e\u6587\u4ef6\u8def\u5f84[%s] \u503c\u975e\u6cd5, \u671f\u671b\u662f\u6574\u6570\u7c7b\u578b: %s. \u8bf7\u68c0\u67e5\u60a8\u7684\u914d\u7f6e\u5e76\u4f5c\u51fa\u4fee\u6539.", path, e.getMessage()));
        }
    }

    public Integer getInt(String path, int defaultValue) {
        Integer object = this.getInt(path);
        if (null == object) {
            return defaultValue;
        }
        return object;
    }

    public Long getLong(String path) {
        String result = this.getString(path);
        if (StringUtils.isBlank((CharSequence)result)) {
            return null;
        }
        try {
            return Long.valueOf(result);
        }
        catch (Exception e) {
            throw DataXException.asDataXException((ErrorCode)CommonErrorCode.CONFIG_ERROR, String.format("\u4efb\u52a1\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6\u51fa\u9519. \u914d\u7f6e\u6587\u4ef6\u8def\u5f84[%s] \u503c\u975e\u6cd5, \u671f\u671b\u662f\u6574\u6570\u7c7b\u578b: %s. \u8bf7\u68c0\u67e5\u60a8\u7684\u914d\u7f6e\u5e76\u4f5c\u51fa\u4fee\u6539.", path, e.getMessage()));
        }
    }

    public Long getLong(String path, long defaultValue) {
        Long result = this.getLong(path);
        if (null == result) {
            return defaultValue;
        }
        return result;
    }

    public Double getDouble(String path) {
        String result = this.getString(path);
        if (StringUtils.isBlank((CharSequence)result)) {
            return null;
        }
        try {
            return Double.valueOf(result);
        }
        catch (Exception e) {
            throw DataXException.asDataXException((ErrorCode)CommonErrorCode.CONFIG_ERROR, String.format("\u4efb\u52a1\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6\u51fa\u9519. \u914d\u7f6e\u6587\u4ef6\u8def\u5f84[%s] \u503c\u975e\u6cd5, \u671f\u671b\u662f\u6d6e\u70b9\u7c7b\u578b: %s. \u8bf7\u68c0\u67e5\u60a8\u7684\u914d\u7f6e\u5e76\u4f5c\u51fa\u4fee\u6539.", path, e.getMessage()));
        }
    }

    public Double getDouble(String path, double defaultValue) {
        Double result = this.getDouble(path);
        if (null == result) {
            return defaultValue;
        }
        return result;
    }

    public List<Object> getList(String path) {
        List list = this.get(path, List.class);
        if (null == list) {
            return null;
        }
        return list;
    }

    public <T> List<T> getList(String path, Class<T> t) {
        List object = this.get(path, List.class);
        if (null == object) {
            return null;
        }
        ArrayList result = new ArrayList();
        List origin = object;
        for (Object each : origin) {
            result.add(each);
        }
        return result;
    }

    public List<Object> getList(String path, List<Object> defaultList) {
        List<Object> object = this.getList(path);
        if (null == object) {
            return defaultList;
        }
        return object;
    }

    public <T> List<T> getList(String path, List<T> defaultList, Class<T> t) {
        List<T> list = this.getList(path, t);
        if (null == list) {
            return defaultList;
        }
        return list;
    }

    public List<Configuration> getListConfiguration(String path) {
        List<Object> lists = this.getList(path);
        if (lists == null) {
            return null;
        }
        ArrayList<Configuration> result = new ArrayList<Configuration>();
        for (Object object : lists) {
            result.add(Configuration.from(Configuration.toJSONString(object)));
        }
        return result;
    }

    public Map<String, Object> getMap(String path) {
        Map result = this.get(path, Map.class);
        if (null == result) {
            return null;
        }
        return result;
    }

    public <T> Map<String, T> getMap(String path, Class<T> t) {
        Map map = this.get(path, Map.class);
        if (null == map) {
            return null;
        }
        HashMap result = new HashMap();
        for (String key : map.keySet()) {
            result.put(key, map.get(key));
        }
        return result;
    }

    public Map<String, Object> getMap(String path, Map<String, Object> defaultMap) {
        Map<String, Object> object = this.getMap(path);
        if (null == object) {
            return defaultMap;
        }
        return object;
    }

    public <T> Map<String, T> getMap(String path, Map<String, T> defaultMap, Class<T> t) {
        Map<String, T> result = this.getMap(path, t);
        if (null == result) {
            return defaultMap;
        }
        return result;
    }

    public Map<String, Configuration> getMapConfiguration(String path) {
        Map map = this.get(path, Map.class);
        if (null == map) {
            return null;
        }
        HashMap<String, Configuration> result = new HashMap<String, Configuration>();
        for (String key : map.keySet()) {
            result.put(key, Configuration.from(Configuration.toJSONString(map.get(key))));
        }
        return result;
    }

    public <T> T get(String path, Class<T> clazz) {
        this.checkPath(path);
        return (T)this.get(path);
    }

    public String beautify() {
        return JSON.toJSONString((Object)this.getInternal(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat});
    }

    public Object set(String path, Object object) {
        this.checkPath(path);
        Object result = this.get(path);
        this.setObject(path, this.extractConfiguration(object));
        return result;
    }

    public Set<String> getKeys() {
        HashSet<String> collect = new HashSet<String>();
        this.getKeysRecursive(this.getInternal(), "", collect);
        return collect;
    }

    public Object remove(String path) {
        Object result = this.get(path);
        if (null == result) {
            throw DataXException.asDataXException((ErrorCode)CommonErrorCode.RUNTIME_ERROR, String.format("\u914d\u7f6e\u6587\u4ef6\u5bf9\u5e94Key[%s]\u5e76\u4e0d\u5b58\u5728\uff0c\u8be5\u60c5\u51b5\u662f\u4ee3\u7801\u7f16\u7a0b\u9519\u8bef. \u8bf7\u8054\u7cfbDataX\u56e2\u961f\u7684\u540c\u5b66.", path));
        }
        this.set(path, null);
        return result;
    }

    public Configuration merge(Configuration another, boolean updateWhenConflict) {
        Set<String> keys = another.getKeys();
        for (String key : keys) {
            boolean isCurrentExists;
            if (updateWhenConflict) {
                this.set(key, another.get(key));
                continue;
            }
            boolean bl = isCurrentExists = this.get(key) != null;
            if (isCurrentExists) continue;
            this.set(key, another.get(key));
        }
        return this;
    }

    public String toString() {
        return this.toJSON();
    }

    public String toJSON() {
        return Configuration.toJSONString(this.getInternal());
    }

    public Configuration clone() {
        Configuration config = Configuration.from(Configuration.toJSONString(this.getInternal()));
        config.addSecretKeyPath(this.secretKeyPathSet);
        return config;
    }

    public void addSecretKeyPath(String path) {
        if (StringUtils.isNotBlank((CharSequence)path)) {
            this.secretKeyPathSet.add(path);
        }
    }

    public void addSecretKeyPath(Set<String> pathSet) {
        if (pathSet != null) {
            this.secretKeyPathSet.addAll(pathSet);
        }
    }

    public void setSecretKeyPathSet(Set<String> keyPathSet) {
        if (keyPathSet != null) {
            this.secretKeyPathSet = keyPathSet;
        }
    }

    public boolean isSecretPath(String path) {
        return this.secretKeyPathSet.contains(path);
    }

    void getKeysRecursive(Object current, String path, Set<String> collect) {
        boolean isRegularElement;
        boolean bl = isRegularElement = !(current instanceof Map) && !(current instanceof List);
        if (isRegularElement) {
            collect.add(path);
            return;
        }
        boolean isMap = current instanceof Map;
        if (isMap) {
            Map mapping = (Map)current;
            for (String key : mapping.keySet()) {
                if (StringUtils.isBlank((CharSequence)path)) {
                    this.getKeysRecursive(mapping.get(key), key.trim(), collect);
                    continue;
                }
                this.getKeysRecursive(mapping.get(key), path + "." + key.trim(), collect);
            }
            return;
        }
        boolean isList = current instanceof List;
        if (isList) {
            List lists = (List)current;
            for (int i = 0; i < lists.size(); ++i) {
                this.getKeysRecursive(lists.get(i), path + String.format("[%d]", i), collect);
            }
            return;
        }
    }

    public Object getInternal() {
        return this.root;
    }

    private void setObject(String path, Object object) {
        Object newRoot = this.setObjectRecursive(this.root, this.split2List(path), 0, object);
        if (this.isSuitForRoot(newRoot)) {
            this.root = newRoot;
            return;
        }
        throw DataXException.asDataXException((ErrorCode)CommonErrorCode.RUNTIME_ERROR, String.format("\u503c[%s]\u65e0\u6cd5\u9002\u914d\u60a8\u63d0\u4f9b[%s]\uff0c \u8be5\u5f02\u5e38\u4ee3\u8868\u7cfb\u7edf\u7f16\u7a0b\u9519\u8bef, \u8bf7\u8054\u7cfbDataX\u5f00\u53d1\u56e2\u961f!", ToStringBuilder.reflectionToString((Object)object), path));
    }

    private Object extractConfiguration(Object object) {
        if (object instanceof Configuration) {
            return this.extractFromConfiguration(object);
        }
        if (object instanceof List) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object each : (List)object) {
                result.add(this.extractFromConfiguration(each));
            }
            return result;
        }
        if (object instanceof Map) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (String key : ((Map)object).keySet()) {
                result.put(key, this.extractFromConfiguration(((Map)object).get(key)));
            }
            return result;
        }
        return object;
    }

    private Object extractFromConfiguration(Object object) {
        if (object instanceof Configuration) {
            return ((Configuration)object).getInternal();
        }
        return object;
    }

    Object buildObject(List<String> paths, Object object) {
        if (null == paths) {
            throw DataXException.asDataXException((ErrorCode)CommonErrorCode.RUNTIME_ERROR, "Path\u4e0d\u80fd\u4e3anull\uff0c\u8be5\u5f02\u5e38\u4ee3\u8868\u7cfb\u7edf\u7f16\u7a0b\u9519\u8bef, \u8bf7\u8054\u7cfbDataX\u5f00\u53d1\u56e2\u961f !");
        }
        if (1 == paths.size() && StringUtils.isBlank((CharSequence)paths.get(0))) {
            return object;
        }
        Cloneable child = object;
        for (int i = paths.size() - 1; i >= 0; --i) {
            String path = paths.get(i);
            if (this.isPathMap(path)) {
                HashMap mapping = new HashMap();
                mapping.put(path, child);
                child = mapping;
                continue;
            }
            if (this.isPathList(path)) {
                ArrayList<Object> lists = new ArrayList<Object>(this.getIndex(path) + 1);
                this.expand(lists, this.getIndex(path) + 1);
                lists.set(this.getIndex(path), child);
                child = lists;
                continue;
            }
            throw DataXException.asDataXException((ErrorCode)CommonErrorCode.RUNTIME_ERROR, String.format("\u8def\u5f84[%s]\u51fa\u73b0\u975e\u6cd5\u503c\u7c7b\u578b[%s]\uff0c\u8be5\u5f02\u5e38\u4ee3\u8868\u7cfb\u7edf\u7f16\u7a0b\u9519\u8bef, \u8bf7\u8054\u7cfbDataX\u5f00\u53d1\u56e2\u961f! .", StringUtils.join(paths, (String)"."), path));
        }
        return child;
    }

    Object setObjectRecursive(Object current, List<String> paths, int index, Object value) {
        boolean isLastIndex;
        boolean bl = isLastIndex = index == paths.size();
        if (isLastIndex) {
            return value;
        }
        String path = paths.get(index).trim();
        boolean isNeedMap = this.isPathMap(path);
        if (isNeedMap) {
            boolean isCurrentMap = current instanceof Map;
            if (!isCurrentMap) {
                HashMap<String, Object> mapping = new HashMap<String, Object>();
                mapping.put(path, this.buildObject(paths.subList(index + 1, paths.size()), value));
                return mapping;
            }
            Map mapping = (Map)current;
            boolean hasSameKey = mapping.containsKey(path);
            if (!hasSameKey) {
                mapping.put(path, this.buildObject(paths.subList(index + 1, paths.size()), value));
                return mapping;
            }
            current = mapping.get(path);
            mapping.put(path, this.setObjectRecursive(current, paths, index + 1, value));
            return mapping;
        }
        boolean isNeedList = this.isPathList(path);
        if (isNeedList) {
            boolean hasSameIndex;
            int listIndexer = this.getIndex(path);
            boolean isCurrentList = current instanceof List;
            if (!isCurrentList) {
                List<Object> lists = this.expand(new ArrayList<Object>(), listIndexer + 1);
                lists.set(listIndexer, this.buildObject(paths.subList(index + 1, paths.size()), value));
                return lists;
            }
            List<Object> lists = (List<Object>)current;
            boolean bl2 = hasSameIndex = (lists = this.expand(lists, listIndexer + 1)).get(listIndexer) != null;
            if (!hasSameIndex) {
                lists.set(listIndexer, this.buildObject(paths.subList(index + 1, paths.size()), value));
                return lists;
            }
            current = lists.get(listIndexer);
            lists.set(listIndexer, this.setObjectRecursive(current, paths, index + 1, value));
            return lists;
        }
        throw DataXException.asDataXException((ErrorCode)CommonErrorCode.RUNTIME_ERROR, "\u8be5\u5f02\u5e38\u4ee3\u8868\u7cfb\u7edf\u7f16\u7a0b\u9519\u8bef, \u8bf7\u8054\u7cfbDataX\u5f00\u53d1\u56e2\u961f !");
    }

    private Object findObject(String path) {
        boolean isRootQuery = StringUtils.isBlank((CharSequence)path);
        if (isRootQuery) {
            return this.root;
        }
        Object target = this.root;
        for (String each : this.split2List(path)) {
            if (this.isPathMap(each)) {
                target = this.findObjectInMap(target, each);
                continue;
            }
            target = this.findObjectInList(target, each);
        }
        return target;
    }

    private Object findObjectInMap(Object target, String index) {
        boolean isMap = target instanceof Map;
        if (!isMap) {
            throw new IllegalArgumentException(String.format("\u60a8\u63d0\u4f9b\u7684\u914d\u7f6e\u6587\u4ef6\u6709\u8bef. \u8def\u5f84[%s]\u9700\u8981\u914d\u7f6eJson\u683c\u5f0f\u7684Map\u5bf9\u8c61\uff0c\u4f46\u8be5\u8282\u70b9\u53d1\u73b0\u5b9e\u9645\u7c7b\u578b\u662f[%s]. \u8bf7\u68c0\u67e5\u60a8\u7684\u914d\u7f6e\u5e76\u4f5c\u51fa\u4fee\u6539.", index, target.getClass().toString()));
        }
        Object result = ((Map)target).get(index);
        if (null == result) {
            throw new IllegalArgumentException(String.format("\u60a8\u63d0\u4f9b\u7684\u914d\u7f6e\u6587\u4ef6\u6709\u8bef. \u8def\u5f84[%s]\u503c\u4e3anull\uff0cdatax\u65e0\u6cd5\u8bc6\u522b\u8be5\u914d\u7f6e. \u8bf7\u68c0\u67e5\u60a8\u7684\u914d\u7f6e\u5e76\u4f5c\u51fa\u4fee\u6539.", index));
        }
        return result;
    }

    private Object findObjectInList(Object target, String each) {
        boolean isList = target instanceof List;
        if (!isList) {
            throw new IllegalArgumentException(String.format("\u60a8\u63d0\u4f9b\u7684\u914d\u7f6e\u6587\u4ef6\u6709\u8bef. \u8def\u5f84[%s]\u9700\u8981\u914d\u7f6eJson\u683c\u5f0f\u7684Map\u5bf9\u8c61\uff0c\u4f46\u8be5\u8282\u70b9\u53d1\u73b0\u5b9e\u9645\u7c7b\u578b\u662f[%s]. \u8bf7\u68c0\u67e5\u60a8\u7684\u914d\u7f6e\u5e76\u4f5c\u51fa\u4fee\u6539.", each, target.getClass().toString()));
        }
        String index = each.replace("[", "").replace("]", "");
        if (!StringUtils.isNumeric((CharSequence)index)) {
            throw new IllegalArgumentException(String.format("\u7cfb\u7edf\u7f16\u7a0b\u9519\u8bef\uff0c\u5217\u8868\u4e0b\u6807\u5fc5\u987b\u4e3a\u6570\u5b57\u7c7b\u578b\uff0c\u4f46\u8be5\u8282\u70b9\u53d1\u73b0\u5b9e\u9645\u7c7b\u578b\u662f[%s] \uff0c\u8be5\u5f02\u5e38\u4ee3\u8868\u7cfb\u7edf\u7f16\u7a0b\u9519\u8bef, \u8bf7\u8054\u7cfbDataX\u5f00\u53d1\u56e2\u961f !", index));
        }
        return ((List)target).get(Integer.valueOf(index));
    }

    private List<Object> expand(List<Object> list, int size) {
        int expand = size - list.size();
        while (expand-- > 0) {
            list.add(null);
        }
        return list;
    }

    private boolean isPathList(String path) {
        return path.contains("[") && path.contains("]");
    }

    private boolean isPathMap(String path) {
        return StringUtils.isNotBlank((CharSequence)path) && !this.isPathList(path);
    }

    private int getIndex(String index) {
        return Integer.valueOf(index.replace("[", "").replace("]", ""));
    }

    private boolean isSuitForRoot(Object object) {
        return null != object && (object instanceof List || object instanceof Map);
    }

    private String split(String path) {
        return StringUtils.replace((String)path, (String)"[", (String)".[");
    }

    private List<String> split2List(String path) {
        return Arrays.asList(StringUtils.split((String)this.split(path), (String)"."));
    }

    private void checkPath(String path) {
        if (null == path) {
            throw new IllegalArgumentException("\u7cfb\u7edf\u7f16\u7a0b\u9519\u8bef, \u8be5\u5f02\u5e38\u4ee3\u8868\u7cfb\u7edf\u7f16\u7a0b\u9519\u8bef, \u8bf7\u8054\u7cfbDataX\u5f00\u53d1\u56e2\u961f!.");
        }
        for (String each : StringUtils.split((String)".")) {
            if (!StringUtils.isBlank((CharSequence)each)) continue;
            throw new IllegalArgumentException(String.format("\u7cfb\u7edf\u7f16\u7a0b\u9519\u8bef, \u8def\u5f84[%s]\u4e0d\u5408\u6cd5, \u8def\u5f84\u5c42\u6b21\u4e4b\u95f4\u4e0d\u80fd\u51fa\u73b0\u7a7a\u767d\u5b57\u7b26 .", path));
        }
    }

    private String toJSONPath(String path) {
        return ((String)(StringUtils.isBlank((CharSequence)path) ? "$" : "$." + path)).replace("$.[", "$[");
    }

    private static void checkJSON(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw DataXException.asDataXException((ErrorCode)CommonErrorCode.CONFIG_ERROR, "\u914d\u7f6e\u4fe1\u606f\u9519\u8bef. \u56e0\u4e3a\u60a8\u63d0\u4f9b\u7684\u914d\u7f6e\u4fe1\u606f\u4e0d\u662f\u5408\u6cd5\u7684JSON\u683c\u5f0f, JSON\u4e0d\u80fd\u4e3a\u7a7a\u767d. \u8bf7\u6309\u7167\u6807\u51c6json\u683c\u5f0f\u63d0\u4f9b\u914d\u7f6e\u4fe1\u606f. ");
        }
    }

    private Configuration(String json) {
        try {
            this.root = JSON.parse((String)json);
        }
        catch (Exception e) {
            throw DataXException.asDataXException((ErrorCode)CommonErrorCode.CONFIG_ERROR, String.format("\u914d\u7f6e\u4fe1\u606f\u9519\u8bef. \u60a8\u63d0\u4f9b\u7684\u914d\u7f6e\u4fe1\u606f\u4e0d\u662f\u5408\u6cd5\u7684JSON\u683c\u5f0f: %s . \u8bf7\u6309\u7167\u6807\u51c6json\u683c\u5f0f\u63d0\u4f9b\u914d\u7f6e\u4fe1\u606f. ", e.getMessage()));
        }
    }

    private static String toJSONString(Object object) {
        return JSON.toJSONString((Object)object);
    }

    public Set<String> getSecretKeyPathSet() {
        return this.secretKeyPathSet;
    }
}

