/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.common.element;

import com.alibaba.datax.common.element.DataXResultPreviewOrderByCols;
import com.alibaba.datax.common.element.PreviewRecords;
import com.alibaba.datax.common.element.QueryCriteria;
import com.alibaba.datax.common.element.Record;
import com.alibaba.datax.common.util.ISelectedTabMeta;
import com.qlangtech.tis.plugin.ds.DataType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class ThreadLocalRows {
    private final List<Record> rows = new ArrayList<Record>();
    private QueryCriteria query;
    private DataXResultPreviewOrderByCols orderByCols;

    public PreviewRecords createPreviewRecords(ISelectedTabMeta tab) {
        int index;
        int pageSize = this.query.getPageSize();
        List<DataXResultPreviewOrderByCols.OffsetColVal> headerCursor = null;
        List<DataXResultPreviewOrderByCols.OffsetColVal> tailerCursor = null;
        Map<String, DataType> typeMap = tab.getCols().stream().collect(Collectors.toMap(col -> col.getName(), col -> col.getType()));
        Iterator<Record> iterator = this.rows.iterator();
        if (iterator.hasNext()) {
            Record record = iterator.next();
            headerCursor = this.createCursor(tab, typeMap, record);
        }
        if ((index = this.rows.size() - 1) >= 0 && index >= pageSize - 1) {
            Record tailerRecord = this.rows.get(index);
            tailerCursor = this.createCursor(tab, typeMap, tailerRecord);
        }
        return new PreviewRecords(this.rows, headerCursor, tailerCursor);
    }

    private List<DataXResultPreviewOrderByCols.OffsetColVal> createCursor(ISelectedTabMeta tab, Map<String, DataType> typeMap, Record record) {
        ArrayList<DataXResultPreviewOrderByCols.OffsetColVal> cursor = new ArrayList<DataXResultPreviewOrderByCols.OffsetColVal>();
        for (String pk : tab.getPrimaryKeys()) {
            cursor.add(new DataXResultPreviewOrderByCols.OffsetColVal(pk, record.getString(pk, true), this.isNumericJdbcType(typeMap, pk)));
        }
        return cursor;
    }

    private boolean isNumericJdbcType(Map<String, DataType> typeMap, String colKey) {
        switch (Objects.requireNonNull(typeMap.get(colKey), "colKey:" + colKey + " relevant dataType can not be null").getCollapse()) {
            case INT: 
            case Long: 
            case Double: 
            case Boolean: {
                return true;
            }
        }
        return false;
    }

    public DataXResultPreviewOrderByCols getPagerOffsetPointCols() {
        return this.orderByCols;
    }

    public void setPagerOffsetPointCols(DataXResultPreviewOrderByCols pagerOffsetPointCols) {
        this.orderByCols = pagerOffsetPointCols;
    }

    public QueryCriteria getQuery() {
        return this.query;
    }

    public void setQuery(QueryCriteria query) {
        this.query = query;
    }

    public void addRecord(Record record) {
        this.rows.add(record);
    }

    public List<Record> getRows() {
        return this.rows;
    }
}

