/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.common.element;

import com.alibaba.datax.common.element.DataXResultPreviewOrderByCols;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Optional;

public class QueryCriteria {
    private List<DataXResultPreviewOrderByCols.OffsetColVal> pagerOffsetCursor;
    private Optional<String> targetPreviewHost = Optional.empty();
    private boolean nextPakge;
    private int pageSize;

    public void setTargetPreviewHost(String targetPreviewHost) {
        this.targetPreviewHost = Optional.of(targetPreviewHost);
    }

    public String getTargetPreviewHost() {
        return this.targetPreviewHost.orElse("127.0.0.1");
    }

    public static QueryCriteria createCriteria(int pageSize, JSONObject jsonPostContent) {
        QueryCriteria queryCriteria = new QueryCriteria();
        queryCriteria.setNextPakge(true);
        queryCriteria.setPageSize(pageSize);
        if (queryCriteria.getPageSize() < 1) {
            throw new IllegalStateException("page size can not small than 1");
        }
        JSONArray offsetPointer = null;
        if (jsonPostContent != null) {
            queryCriteria.setNextPakge(jsonPostContent.getBooleanValue("nextPage"));
            offsetPointer = jsonPostContent.getJSONArray("offsetPointer");
        }
        if (offsetPointer != null) {
            List<DataXResultPreviewOrderByCols.OffsetColVal> pagerOffsetCursor = DataXResultPreviewOrderByCols.OffsetColVal.deserializePreviewCursor(offsetPointer);
            queryCriteria.setPagerOffsetCursor(pagerOffsetCursor);
        }
        return queryCriteria;
    }

    public List<DataXResultPreviewOrderByCols.OffsetColVal> getPagerOffsetCursor() {
        return this.pagerOffsetCursor;
    }

    public void setPagerOffsetCursor(List<DataXResultPreviewOrderByCols.OffsetColVal> pagerOffsetCursor) {
        this.pagerOffsetCursor = pagerOffsetCursor;
    }

    public boolean isNextPakge() {
        return this.nextPakge;
    }

    public int getPageSize() {
        if (this.pageSize < 1) {
            throw new IllegalStateException("property pageSize can not small than 1");
        }
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setNextPakge(boolean nextPakge) {
        this.nextPakge = nextPakge;
    }
}

