/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.datax.common.element;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.qlangtech.tis.plugin.ds.IDBReservedKeys;
import java.util.ArrayList;
import java.util.List;

public class DataXResultPreviewOrderByCols {
    private final boolean first;
    private List<OffsetColVal> offsetCols = new ArrayList<OffsetColVal>();

    public DataXResultPreviewOrderByCols(boolean first) {
        this.first = first;
    }

    public List<OffsetColVal> getOffsetCols() {
        return this.offsetCols;
    }

    public void addOffsetColVal(OffsetColVal colVal) {
        this.offsetCols.add(colVal);
    }

    public String createWhereAndOrderByStatment(boolean nextPakge, IDBReservedKeys dbReservedKeys) {
        if (this.offsetCols.size() < 1) {
            throw new IllegalStateException("offsetCols size can not small than 1");
        }
        StringBuilder buffer = new StringBuilder();
        boolean firstProcessed = false;
        if (!this.first) {
            buffer.append(" WHERE ");
            for (OffsetColVal colVal : this.offsetCols) {
                if (firstProcessed) {
                    buffer.append(" AND ");
                }
                buffer.append(dbReservedKeys.getEscapedEntity(colVal.colKey)).append(nextPakge ? ">" : "<").append(colVal.getLiteriaVal());
                firstProcessed = true;
            }
        }
        buffer.append("\n");
        buffer.append("ORDER BY ");
        firstProcessed = false;
        for (OffsetColVal colVal : this.offsetCols) {
            if (firstProcessed) {
                buffer.append(",");
            }
            buffer.append(dbReservedKeys.getEscapedEntity(colVal.colKey)).append(" ").append(nextPakge ? "ASC" : "DESC");
            firstProcessed = true;
        }
        return buffer.toString();
    }

    public static class OffsetColVal {
        private final String colKey;
        private final String val;
        private final Boolean isNumericJdbcType;
        private static final String KEY = "key";
        private static final String VAL = "val";
        private static final String NUMERIC = "numeric";

        public static JSONArray getPreviewCursor(List<OffsetColVal> cursorVals) {
            JSONArray vals = new JSONArray();
            JSONObject val = null;
            for (OffsetColVal colVal : cursorVals) {
                val = new JSONObject();
                val.put(KEY, (Object)colVal.getColKey());
                val.put(VAL, (Object)colVal.getVal());
                val.put(NUMERIC, (Object)colVal.isNumericJdbcType());
                vals.add((Object)val);
            }
            return vals;
        }

        public static List<OffsetColVal> deserializePreviewCursor(JSONArray cursorVals) {
            ArrayList<OffsetColVal> vals = new ArrayList<OffsetColVal>();
            JSONObject j = null;
            for (Object o : cursorVals) {
                j = (JSONObject)o;
                vals.add(new OffsetColVal(j.getString(KEY), j.getString(VAL), j.getBoolean(NUMERIC)));
            }
            return vals;
        }

        private String getLiteriaVal() {
            if (this.isNumericJdbcType == null) {
                throw new IllegalStateException("property isNumericJdbcType can not be null");
            }
            if (this.val == null) {
                throw new IllegalStateException("property val can not be null");
            }
            return this.isNumericJdbcType != false ? this.val : "'" + this.val + "'";
        }

        public OffsetColVal(String colKey, String val, Boolean isNumericJdbcType) {
            this.colKey = colKey;
            this.val = val;
            this.isNumericJdbcType = isNumericJdbcType;
        }

        public String getColKey() {
            return this.colKey;
        }

        public String getVal() {
            return this.val;
        }

        public Boolean isNumericJdbcType() {
            return this.isNumericJdbcType;
        }
    }
}

