/*
 * Decompiled with CFR 0.152.
 */
package org.shai.xmodifier;

import java.util.Arrays;
import java.util.Map;
import org.shai.xmodifier.util.Cons;
import org.shai.xmodifier.util.StringUtils;

public class XModifyNode {
    private final Map<String, String> nsMap;
    private final String xPath;
    private final String value;
    private final String[] elements;
    private final String[] elementXPaths;
    private int index = 0;
    private String nsPrefix;
    private String namespaceURI;
    private String localName;
    private String[] conditions;
    private String mark;

    public XModifyNode(Map<String, String> nsMap, String xPath, String value) {
        this.nsMap = nsMap;
        this.xPath = xPath.contains("(:") ? StringUtils.removeQuotingString(xPath, new Cons<String, String>("(:", ")"), Arrays.asList(new Cons<String, String>("(", ")"))) : xPath;
        this.value = value;
        this.index = 0;
        this.elements = StringUtils.splitBySeparator(xPath, new String[]{"/", "//"}, (char[][])new char[][]{{'\'', '\''}, {'[', ']'}, {'(', ')'}}, false);
        this.elementXPaths = StringUtils.removeMarks(StringUtils.splitBySeparator(xPath, new String[]{"/", "//"}, (char[][])new char[][]{{'\'', '\''}, {'[', ']'}, {'(', ')'}}, true));
        for (int i = 0; i < this.elementXPaths.length; ++i) {
            if (i == 0) continue;
            this.elementXPaths[i] = "." + this.elementXPaths[i];
        }
        this.analyzeCurrentNode();
    }

    private XModifyNode(Map<String, String> nsMap, String xPath, String value, String[] elements, String[] elementXPaths, int index) {
        this.nsMap = nsMap;
        this.xPath = xPath;
        this.value = value;
        this.elements = elements;
        this.elementXPaths = elementXPaths;
        this.index = index;
        this.analyzeCurrentNode();
    }

    public String getCurNode() {
        return this.elements[this.index];
    }

    public String getPreNode() {
        if (this.index - 1 >= 0) {
            return this.elements[this.index - 1];
        }
        return null;
    }

    public boolean moveNext() {
        if (this.index >= this.elements.length - 1) {
            return false;
        }
        ++this.index;
        this.analyzeCurrentNode();
        return true;
    }

    private void analyzeCurrentNode() {
        String[] split;
        String nodeExpression = this.getCurNode();
        String temp = nodeExpression.trim();
        if (nodeExpression.contains("(:")) {
            Cons<String, String> findingResult = StringUtils.findFirstQuotingString(nodeExpression, new Cons<String, String>("(:", ")"), Arrays.asList(new Cons<String, String>("(", ")")));
            this.mark = findingResult.getLeft();
            temp = findingResult.getRight();
        }
        if ((split = StringUtils.splitBySeparator(temp, ':', (char[][])new char[][]{{'\'', '\''}, {'[', ']'}, {'(', ')'}}, false))[1] != null) {
            this.nsPrefix = StringUtils.trimToNull(split[0]);
            temp = split[1];
        }
        this.namespaceURI = this.nsMap.get(this.nsPrefix);
        split = StringUtils.splitBySeparator(temp, '[', true);
        if (split[1] == null) {
            this.localName = StringUtils.trimToNull(split[0]);
            return;
        }
        this.localName = StringUtils.trimToNull(split[0]);
        temp = split[1];
        split = temp.substring(1).split("\\[");
        this.conditions = new String[split.length];
        for (int i = 0; i < split.length; ++i) {
            String s = split[i];
            this.conditions[i] = StringUtils.stripEnd(s, "]");
        }
    }

    public String getValue() {
        return this.value;
    }

    public boolean isAttributeModifier() {
        return this.getCurNode().startsWith("@");
    }

    public boolean isRootNode() {
        return this.index == 0 && StringUtils.isEmpty(this.getCurNode());
    }

    public String getXPath() {
        return this.xPath;
    }

    public String getCurNodeXPath() {
        return this.elementXPaths[this.index];
    }

    public String getNsPrefix() {
        return this.nsPrefix;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String[] getConditions() {
        return this.conditions;
    }

    public String getMark() {
        return this.mark;
    }

    public String toString() {
        return "XModifyNode{xPath='" + this.xPath + "', value='" + this.value + "', index=" + this.index + "}";
    }

    public XModifyNode duplicate() {
        return new XModifyNode(this.nsMap, this.xPath, this.value, this.elements, this.elementXPaths, this.index);
    }

    public boolean isAdding() {
        return this.mark != null && this.mark.equals("add");
    }

    public boolean isDeleting() {
        return this.mark != null && this.mark.equals("delete");
    }

    public boolean isInsertBefore() {
        return this.mark != null && this.mark.startsWith("insertBefore");
    }

    public String getInsertBeforeXPath() {
        Cons<String, String> result = StringUtils.findFirstQuotingString(this.mark, new Cons<String, String>("insertBefore(", ")"), Arrays.asList(new Cons<String, String>("(", ")")));
        if (result != null) {
            return "./" + result.getLeft();
        }
        return null;
    }
}

