/*
 * Decompiled with CFR 0.152.
 */
package org.shai.xmodifier;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.shai.xmodifier.XModifyNode;
import org.shai.xmodifier.exception.XModifyFailException;
import org.shai.xmodifier.util.ArrayUtils;
import org.shai.xmodifier.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XModifier {
    private final Document document;
    private Map<String, String> nsMap = new HashMap<String, String>();
    private List<XModifyNode> xModifyNodes = new ArrayList<XModifyNode>();
    private XPath xPathEvaluator;

    public XModifier(Document document) {
        this.document = document;
    }

    public void setNamespace(String prefix, String url) {
        this.nsMap.put(prefix, url);
    }

    public void addModify(String xPath, String value) {
        this.xModifyNodes.add(new XModifyNode(this.nsMap, xPath, value));
    }

    public void addModify(String xPath) {
        this.xModifyNodes.add(new XModifyNode(this.nsMap, xPath, null));
    }

    public void modify() {
        this.initXPath();
        for (XModifyNode xModifyNode : this.xModifyNodes) {
            try {
                this.create(this.document, xModifyNode);
            }
            catch (Exception e) {
                throw new XModifyFailException(xModifyNode.toString(), e);
            }
        }
    }

    private void create(Node parent, XModifyNode node) throws XPathExpressionException {
        if (node.isAttributeModifier()) {
            this.createAttributeByXPath(parent, node.getCurNode().substring(1), node.getValue());
        } else if (node.isRootNode()) {
            Node newNode = parent;
            boolean canMoveToNext = node.moveNext();
            if (!canMoveToNext) {
                newNode.setTextContent(node.getValue());
            } else {
                this.create(newNode, node);
            }
        } else if (node.getCurNode().equals("text()")) {
            parent.setTextContent(node.getValue());
        } else {
            this.findOrCreateElement(parent, node);
        }
    }

    private void initXPath() {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        xPath.setNamespaceContext(new NamespaceContext(){

            @Override
            public String getNamespaceURI(String prefix) {
                return XModifier.this.nsMap.get(prefix);
            }

            @Override
            public String getPrefix(String namespaceURI) {
                for (Map.Entry<String, String> entry : XModifier.this.nsMap.entrySet()) {
                    if (!entry.getValue().equals(namespaceURI)) continue;
                    return entry.getKey();
                }
                return null;
            }

            public Iterator getPrefixes(String namespaceURI) {
                return XModifier.this.nsMap.keySet().iterator();
            }
        });
        this.xPathEvaluator = xPath;
    }

    private void createAttributeByXPath(Node node, String current, String value) {
        ((Element)node).setAttribute(current, value);
    }

    private void findOrCreateElement(Node parent, XModifyNode node) throws XPathExpressionException {
        if (node.isAdding()) {
            Element newCreatedNode = this.createNewElement(node.getNamespaceURI(), node.getLocalName(), node.getConditions());
            parent.appendChild(newCreatedNode);
            boolean canMoveToNext = node.moveNext();
            if (!canMoveToNext) {
                newCreatedNode.setTextContent(node.getValue());
            } else {
                this.create(newCreatedNode, node);
            }
            return;
        }
        if (node.isInsertBefore()) {
            Element newCreatedNode = this.createNewElement(node.getNamespaceURI(), node.getLocalName(), node.getConditions());
            Node referNode = (Node)this.xPathEvaluator.evaluate(node.getInsertBeforeXPath(), parent, XPathConstants.NODE);
            parent.insertBefore(newCreatedNode, referNode);
            boolean canMoveToNext = node.moveNext();
            if (!canMoveToNext) {
                newCreatedNode.setTextContent(node.getValue());
            } else {
                this.create(newCreatedNode, node);
            }
            return;
        }
        NodeList existNodeList = (NodeList)this.xPathEvaluator.evaluate(node.getCurNodeXPath(), parent, XPathConstants.NODESET);
        if (existNodeList.getLength() > 0) {
            for (int i = 0; i < existNodeList.getLength(); ++i) {
                XModifyNode newNode = node.duplicate();
                Node item = existNodeList.item(i);
                if (node.isDeleting()) {
                    parent.removeChild(item);
                    continue;
                }
                boolean canMoveToNext = newNode.moveNext();
                if (!canMoveToNext) {
                    item.setTextContent(node.getValue());
                    continue;
                }
                this.create(item, newNode);
            }
        } else {
            Element newCreatedNode = this.createNewElement(node.getNamespaceURI(), node.getLocalName(), node.getConditions());
            parent.appendChild(newCreatedNode);
            Node checkExistNode = (Node)this.xPathEvaluator.evaluate(node.getCurNodeXPath(), parent, XPathConstants.NODE);
            if (!newCreatedNode.equals(checkExistNode)) {
                throw new XModifyFailException("Error to create " + node.getCurNode());
            }
            boolean canMoveToNext = node.moveNext();
            if (!canMoveToNext) {
                newCreatedNode.setTextContent(node.getValue());
            } else {
                this.create(newCreatedNode, node);
            }
        }
    }

    private Element createNewElement(String namespaceURI, String local, String[] conditions) throws XPathExpressionException {
        Element newElement = null;
        newElement = namespaceURI != null ? this.document.createElementNS(namespaceURI, local) : this.document.createElement(local);
        if (ArrayUtils.isNotEmpty(conditions)) {
            for (String condition : conditions) {
                if (StringUtils.containsOnly(condition, "0123456789") || condition.startsWith("not")) continue;
                String[] strings = StringUtils.splitBySeparator(condition, '=');
                String xpath = strings[0];
                String value = StringUtils.unquote(strings[1]);
                this.create(newElement, new XModifyNode(this.nsMap, xpath, value));
            }
        }
        return newElement;
    }
}

