/*
 * Decompiled with CFR 0.152.
 */
package com.yushu.tis.xmodifier;

import com.qlangtech.tis.runtime.module.action.IModifierProcess;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.jdom2.Content;
import org.jdom2.DocType;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.filter.ElementFilter;
import org.jdom2.filter.Filter;
import org.jdom2.filter.Filters;
import org.jdom2.input.SAXBuilder;
import org.jdom2.input.sax.XMLReaderJDOMFactory;
import org.jdom2.input.sax.XMLReaderSAX2Factory;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;
import org.shai.xmodifier.XModifyNode;
import org.shai.xmodifier.exception.XModifyFailException;
import org.shai.xmodifier.util.ArrayUtils;
import org.shai.xmodifier.util.StringUtils;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XModifier {
    private static final SAXBuilder saxBuilder = new SAXBuilder((XMLReaderJDOMFactory)new XMLReaderSAX2Factory(false));
    private static final Format xmlPrettyformat = Format.getPrettyFormat().setEncoding(StandardCharsets.UTF_8.name());
    private static final Format xmlRawformat = Format.getRawFormat().setEncoding(StandardCharsets.UTF_8.name());
    private final Document document;
    private Map<String, String> nsMap = new HashMap<String, String>();
    private List<XModifyNode> xModifyNodes = new ArrayList<XModifyNode>();
    private XPathFactory factory;

    public XModifier(Document document) {
        this.document = document;
    }

    public static byte[] modifySchemaContent(byte[] content, IModifierProcess contentModifier) throws Exception {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(content);
        Document document2 = saxBuilder.build((InputStream)inputStream);
        XModifier modifier = new XModifier(document2);
        contentModifier.process(document2, modifier);
        modifier.modify();
        XMLOutputter xmlout = new XMLOutputter(xmlPrettyformat);
        xmlout.setFormat(xmlPrettyformat.setEncoding(StandardCharsets.UTF_8.name()));
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            byte[] byArray;
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);){
                xmlout.output(document2, (Writer)writer);
                writer.flush();
                byArray = out.toByteArray();
            }
            return byArray;
        }
    }

    public void setNamespace(String prefix, String url) {
        this.nsMap.put(prefix, url);
    }

    public void deleteUniqueKey() {
        this.addModify("/uniqueKey(:delete)");
    }

    public void deleteSharedKey() {
        this.addModify("/sharedKey(:delete)");
    }

    public void addModify(String xPath, String value) {
        this.xModifyNodes.add(new XModifyNode(this.nsMap, xPath, value));
    }

    public void addModify(String xPath) {
        this.xModifyNodes.add(new XModifyNode(this.nsMap, xPath, null));
    }

    private void modify() {
        this.initXPath();
        for (XModifyNode xModifyNode : this.xModifyNodes) {
            try {
                this.create(this.document.getRootElement(), xModifyNode);
            }
            catch (Exception e) {
                throw new XModifyFailException(xModifyNode.toString(), e);
            }
        }
    }

    public static void main(String[] arg) throws Exception {
        SAXBuilder builder = new SAXBuilder((XMLReaderJDOMFactory)new XMLReaderSAX2Factory(false));
        builder.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                InputSource source = new InputSource();
                source.setCharacterStream(new StringReader(""));
                return source;
            }
        });
        FileInputStream inputStream = new FileInputStream(new File("D:\\home\\schema.xml"));
        Document document = builder.build((InputStream)inputStream);
        XModifier modifier = new XModifier(document);
        modifier.addModify("/types/fieldType[@name='singleString']/@class", "java.lang.String");
        modifier.addModify("/types/fieldType[@name='kkkkkkkk']/@class", "ddddddd");
        modifier.addModify("/types/fieldType[@name='xxxxxx'][@class='java.lang.String']");
        modifier.addModify("/uniqueKey/text()", "ddddddd");
        modifier.addModify("/fields/field[@name='email_dynamic_info'](:delete)");
        modifier.modify();
        Format format = Format.getPrettyFormat();
        DocType docType = new DocType("schema", "http://tis.qlangtech.com:9999/dtd/solrschema.dtd");
        document.setDocType(docType);
        XMLOutputter xmlout = new XMLOutputter(format);
        xmlout.setFormat(format.setEncoding("utf8"));
        ByteArrayOutputStream byteRsp = new ByteArrayOutputStream();
        xmlout.output(document, (OutputStream)byteRsp);
        System.out.println(byteRsp.toString("utf8"));
    }

    private void create(Element parent, XModifyNode node) throws XPathExpressionException {
        if (node.isAttributeModifier()) {
            this.createAttributeByXPath((Content)parent, node.getCurNode().substring(1), node.getValue());
        } else if (node.isRootNode()) {
            Element newNode = parent;
            boolean canMoveToNext = node.moveNext();
            if (!canMoveToNext) {
                newNode.setText(node.getValue());
            } else {
                this.create(newNode, node);
            }
        } else if (node.getCurNode().equals("text()")) {
            parent.setText(node.getValue());
        } else {
            this.findOrCreateElement(parent, node);
        }
    }

    private void initXPath() {
        this.factory = XPathFactory.instance();
    }

    private void createAttributeByXPath(Content node, String current, String value) {
        ((Element)node).setAttribute(current, value);
    }

    private void findOrCreateElement(Element parent, XModifyNode node) throws XPathExpressionException {
        XPathExpression xpath;
        List existNodeList;
        if (node.isAdding()) {
            Element newCreatedNode = this.createNewElement(node.getNamespaceURI(), node.getLocalName(), node.getConditions());
            parent.addContent((Content)newCreatedNode);
            boolean canMoveToNext = node.moveNext();
            if (!canMoveToNext) {
                newCreatedNode.setText(node.getValue());
            } else {
                this.create(newCreatedNode, node);
            }
            return;
        }
        if (node.isInsertBefore()) {
            // empty if block
        }
        if ((existNodeList = (xpath = this.factory.compile(node.getCurNodeXPath(), Filters.element())).evaluate((Object)parent)).size() > 0) {
            for (int i = 0; i < existNodeList.size(); ++i) {
                XModifyNode newNode = node.duplicate();
                Element item = (Element)existNodeList.get(i);
                if (node.isDeleting()) {
                    parent.removeContent((Content)item);
                    continue;
                }
                boolean canMoveToNext = newNode.moveNext();
                if (!canMoveToNext) {
                    item.setText(node.getValue());
                    continue;
                }
                this.create(item, newNode);
            }
        } else {
            Element newCreatedNode = this.createNewElement(node.getNamespaceURI(), node.getLocalName(), node.getConditions());
            parent.addContent((Content)newCreatedNode);
            xpath = this.factory.compile(node.getCurNodeXPath(), (Filter)new ElementFilter());
            Element checkExistNode = (Element)xpath.evaluateFirst((Object)parent);
            if (!newCreatedNode.equals((Object)checkExistNode)) {
                throw new XModifyFailException("Error to create " + node.getCurNode());
            }
            boolean canMoveToNext = node.moveNext();
            if (!canMoveToNext) {
                newCreatedNode.setText(node.getValue());
            } else {
                this.create(newCreatedNode, node);
            }
        }
    }

    private Element createNewElement(String namespaceURI, String local, String[] conditions) throws XPathExpressionException {
        Element newElement = null;
        newElement = namespaceURI != null ? new Element(local, namespaceURI) : new Element(local);
        if (ArrayUtils.isNotEmpty(conditions)) {
            for (String condition : conditions) {
                if (StringUtils.containsOnly(condition, "0123456789") || condition.startsWith("not")) continue;
                String[] strings = StringUtils.splitBySeparator(condition, '=');
                String xpath = strings[0];
                String value = StringUtils.unquote(strings[1]);
                this.create(newElement, new XModifyNode(this.nsMap, xpath, value));
            }
        }
        return newElement;
    }

    static {
        saxBuilder.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                InputSource source = new InputSource();
                source.setCharacterStream(new StringReader(""));
                return source;
            }
        });
    }
}

