/*
 * Decompiled with CFR 0.152.
 */
package com.tis.hadoop.rpc;

import com.qlangtech.tis.fullbuild.phasestatus.PhaseStatusCollection;
import com.qlangtech.tis.fullbuild.phasestatus.impl.BuildSharedPhaseStatus;
import com.qlangtech.tis.fullbuild.phasestatus.impl.DumpPhaseStatus;
import com.qlangtech.tis.fullbuild.phasestatus.impl.JoinPhaseStatus;
import com.qlangtech.tis.realtime.yarn.rpc.LaunchReportInfo;
import com.qlangtech.tis.realtime.yarn.rpc.MasterJob;
import com.qlangtech.tis.realtime.yarn.rpc.PingResult;
import com.qlangtech.tis.realtime.yarn.rpc.UpdateCounterMap;
import com.qlangtech.tis.rpc.grpc.log.ILoggerAppenderClient;
import com.qlangtech.tis.trigger.jst.ILogListener;
import com.tis.hadoop.rpc.GrpcConnectionException;
import com.tis.hadoop.rpc.IPartialGrpcServiceFacade;
import com.tis.hadoop.rpc.ITISRpcService;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcServiceReference
implements IPartialGrpcServiceFacade {
    private final AtomicReference<ITISRpcService> ref;
    private final Runnable connect;
    private final ITISRpcService mockSvc;
    private static final Logger logger = LoggerFactory.getLogger(RpcServiceReference.class);

    public RpcServiceReference(AtomicReference<ITISRpcService> ref, ITISRpcService mockSvc, Runnable connect) {
        this.ref = ref;
        this.mockSvc = mockSvc;
        this.connect = connect;
    }

    public AtomicReference<ITISRpcService> getRef() {
        return this.ref;
    }

    @Override
    public void close() {
        this.get().close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reConnect() {
        Runnable runnable = this.connect;
        synchronized (runnable) {
            this.connect.notifyAll();
        }
    }

    private <T extends ITISRpcService> T get() {
        ITISRpcService t = this.ref.get();
        return (T)t;
    }

    public void reportDumpJobStatus(boolean faild, boolean complete, boolean waiting, Integer taskId, String jobName, int readRows, int allRows) {
        RpcServiceReference svc = this;
        DumpPhaseStatus.TableDumpStatus dumpStatus = new DumpPhaseStatus.TableDumpStatus(jobName, taskId);
        dumpStatus.setFaild(faild);
        dumpStatus.setComplete(complete);
        dumpStatus.setWaiting(waiting);
        dumpStatus.setReadRows(readRows);
        dumpStatus.setAllRows(allRows);
        svc.reportDumpTableStatus(dumpStatus);
    }

    @Override
    public <STREAM_OBSERVER> STREAM_OBSERVER registerMonitorEvent(ILogListener logListener) {
        return (STREAM_OBSERVER)this.invokeRpc(svc -> svc.registerMonitorEvent(logListener));
    }

    private <T> T invokeRpc(Function<ITISRpcService, T> func) {
        try {
            return func.apply((ITISRpcService)Objects.requireNonNull(this.get(), "instance of " + ITISRpcService.class.getSimpleName() + " can not be null"));
        }
        catch (GrpcConnectionException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            this.reConnect();
            return func.apply(this.mockSvc);
        }
    }

    @Override
    public <PHASE_STATUS_COLLECTION> Iterator<PHASE_STATUS_COLLECTION> buildPhraseStatus(Integer taskid) {
        return this.invokeRpc(svc -> svc.buildPhraseStatus(taskid));
    }

    @Override
    public PingResult ping() {
        return this.invokeRpc(svc -> svc.ping());
    }

    @Override
    public MasterJob reportStatus(UpdateCounterMap upateCounter) {
        return this.invokeRpc(svc -> svc.reportStatus(upateCounter));
    }

    @Override
    public void nodeLaunchReport(LaunchReportInfo launchReportInfo) {
        this.invokeRpc(svc -> {
            svc.nodeLaunchReport(launchReportInfo);
            return null;
        });
    }

    @Override
    public void reportDumpTableStatus(DumpPhaseStatus.TableDumpStatus tableDumpStatus) {
        this.invokeRpc(svc -> {
            svc.reportDumpTableStatus(tableDumpStatus);
            return null;
        });
    }

    @Override
    public void reportJoinStatus(Integer taskId, JoinPhaseStatus.JoinTaskStatus joinTaskStatus) {
        this.invokeRpc(svc -> {
            svc.reportJoinStatus(taskId, joinTaskStatus);
            return null;
        });
    }

    @Override
    public void reportBuildIndexStatus(BuildSharedPhaseStatus buildStatus) {
        this.invokeRpc(svc -> {
            svc.reportBuildIndexStatus(buildStatus);
            return null;
        });
    }

    @Override
    public void initSynJob(PhaseStatusCollection buildStatus) {
        this.invokeRpc(svc -> {
            svc.initSynJob(buildStatus);
            return null;
        });
    }

    @Override
    public PhaseStatusCollection loadPhaseStatusFromLatest(Integer taskId) {
        return this.invokeRpc(svc -> svc.loadPhaseStatusFromLatest(taskId));
    }

    @Override
    public void appendLog(ILoggerAppenderClient.LogLevel level, Integer taskId, Optional<String> appName, String message) {
        this.invokeRpc(svc -> {
            svc.appendLog(level, taskId, appName, message);
            return null;
        });
    }

    @Override
    public void append(Map<String, String> headers, ILoggerAppenderClient.LogLevel level, String body) {
        this.invokeRpc(svc -> {
            svc.append(headers, level, body);
            return null;
        });
    }
}

