/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.utils;

import com.google.common.util.concurrent.RateLimiter;
import com.qlangtech.tis.manage.common.Config;
import com.qlangtech.tis.manage.common.TisUTF8;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.commons.io.FileUtils;

public class FreshmanReadmeToken {
    public static final RateLimiter rateLimiter = RateLimiter.create((double)0.5);
    private static FreshmanReadmeToken freshmanReadmeToken = null;
    private final File readFreshManTokenFile;
    private final long lastAccessEpochMilli;
    private boolean neverOpenAgain = false;

    public FreshmanReadmeToken(File readFreshManTokenFile) {
        this.readFreshManTokenFile = readFreshManTokenFile;
        try {
            if (!readFreshManTokenFile.exists()) {
                this.lastAccessEpochMilli = 0L;
            } else {
                String tokenContent = FileUtils.readFileToString((File)readFreshManTokenFile, (Charset)TisUTF8.get());
                this.lastAccessEpochMilli = Long.parseLong(tokenContent);
                if (this.lastAccessEpochMilli == Long.MAX_VALUE) {
                    this.neverOpenAgain = true;
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setFreshManReadmeHasRead(boolean remindMeLater) {
        FreshmanReadmeToken readFreshManToken = FreshmanReadmeToken.getReadFreshManTokenFile();
        readFreshManToken.setHasRead(remindMeLater);
        freshmanReadmeToken = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FreshmanReadmeToken getReadFreshManTokenFile() {
        if (freshmanReadmeToken != null) return freshmanReadmeToken;
        Class<FreshmanReadmeToken> clazz = FreshmanReadmeToken.class;
        synchronized (FreshmanReadmeToken.class) {
            if (freshmanReadmeToken != null) return freshmanReadmeToken;
            freshmanReadmeToken = new FreshmanReadmeToken(new File(Config.getDataDir(), "freshman_readme_token"));
            // ** MonitorExit[var0] (shouldn't be in output)
            return freshmanReadmeToken;
        }
    }

    public static boolean hasReadFreshManReadme() {
        if (!rateLimiter.tryAcquire()) {
            return true;
        }
        FreshmanReadmeToken readFreshManToken = FreshmanReadmeToken.getReadFreshManTokenFile();
        return readFreshManToken.isValid();
    }

    public void setHasRead(boolean remindMeLater) {
        try {
            FileUtils.write((File)this.readFreshManTokenFile, (CharSequence)(remindMeLater ? String.valueOf(System.currentTimeMillis() + 604800000L) : String.valueOf(Long.MAX_VALUE)), (Charset)TisUTF8.get(), (boolean)false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isValid() {
        if (this.neverOpenAgain) {
            return true;
        }
        return System.currentTimeMillis() < this.lastAccessEpochMilli;
    }
}

