/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.util;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson2.JSONWriter;
import com.qlangtech.tis.trigger.util.JsonUtil;
import com.qlangtech.tis.util.DescriptorsJSONResult;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.tuple.Pair;

public class DescriptorsJSONResultSerializer
implements ObjectSerializer {
    public void write(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        boolean prettyFormat = SerializerFeature.isEnabled((int)((int)features), (SerializerFeature)SerializerFeature.PrettyFormat);
        DescriptorsJSONResult value = (DescriptorsJSONResult)object;
        Objects.requireNonNull(value, "callable of " + fieldName + " can not be null");
        jsonWriter.writeRaw(this.toJSONString(value, prettyFormat));
    }

    public String toJSONString(DescriptorsJSONResult value, boolean prettyFormat) {
        JSONObject o = new JSONObject();
        int fieldSize = value.descs.size();
        StringBuilder json = new StringBuilder();
        json.append("{");
        if (prettyFormat) {
            json.append("\n");
        }
        int fieldIndex = 0;
        for (Map.Entry<String, Pair<JSONObject, Object>> entry : value.descs.entrySet()) {
            try {
                if (value.rootDesc) {
                    DescriptorsJSONResult.rootDescriptorLocal.set(entry.getValue().getValue());
                }
                json.append("\t\"").append(entry.getKey()).append("\":").append(JsonUtil.toString(entry.getValue().getLeft(), prettyFormat));
                if (++fieldIndex >= fieldSize) continue;
                json.append(",");
            }
            catch (Exception e) {
                throw new IllegalStateException(entry.getKey() + " " + entry.getValue().getValue().getClass(), e);
            }
            finally {
                if (!value.rootDesc) continue;
                DescriptorsJSONResult.rootDescriptorLocal.remove();
            }
        }
        if (prettyFormat) {
            json.append("\n");
        }
        json.append("}");
        return json.toString();
    }

    public void write(JSONSerializer jsonSerializer, Object o, Object o1, Type type, int i) throws IOException {
        throw new UnsupportedEncodingException();
    }
}

