/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.util;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONType;
import com.google.common.collect.Maps;
import com.qlangtech.tis.util.DescriptorsJSONResultSerializer;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

@JSONType(serializer=DescriptorsJSONResultSerializer.class)
public class DescriptorsJSONResult {
    public static final ThreadLocal<Object> rootDescriptorLocal = new ThreadLocal();
    Map<String, Pair<JSONObject, Object>> descs = Maps.newHashMap();
    final boolean rootDesc;

    public static <T> T getRootDescInstance() {
        return (T)Objects.requireNonNull(rootDescriptorLocal.get(), "rootDescriptorLocal element can not be null");
    }

    public DescriptorsJSONResult(boolean rootDesc) {
        this.rootDesc = rootDesc;
    }

    public void addDesc(String id, JSONObject descJson, Object desc) {
        this.descs.put(id, (Pair<JSONObject, Object>)Pair.of((Object)descJson, (Object)desc));
    }

    public JSONObject getJSONObject(String descId) {
        return (JSONObject)Objects.requireNonNull(this.descs.get(descId), "descId:" + descId + " relevant desc can not be null").getLeft();
    }

    public Map<String, JSONObject> getDescriptorsResult() {
        return this.descs.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> (JSONObject)((Pair)e.getValue()).getLeft()));
    }
}

