/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.trigger.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.collect.Lists;
import com.qlangtech.tis.extension.impl.IOUtils;
import com.qlangtech.tis.util.DescriptorsJSONResult;
import com.qlangtech.tis.web.start.TisAppLaunch;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONTokener;

public class JsonUtil {
    private JsonUtil() {
    }

    public static <T extends HashMap<String, String>> T deserialize(String value, T object) {
        try {
            JSONTokener tokener = new JSONTokener(value);
            org.json.JSONObject json = new org.json.JSONObject(tokener);
            Iterator it = json.keys();
            String key = null;
            while (it.hasNext()) {
                key = (String)it.next();
                object.put((String)key, (String)json.getString(key));
            }
            return object;
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public static String serialize(Map<String, String> param) {
        org.json.JSONObject json = new org.json.JSONObject(param);
        return JsonUtil.toString(json);
    }

    public static <T> T[] toArray(Class<T> elementClazz, JSONArray ms) {
        Object[] t = (Object[])Array.newInstance(elementClazz, ms.size());
        int i = 0;
        for (Object e : ms.toArray()) {
            t[i++] = e;
        }
        return t;
    }

    public static boolean objEquals(JSONObject o1, JSONObject o2, Set<String> ignorePaths) {
        StringBuffer vistPath = new StringBuffer();
        return JsonUtil.objEquals(o1, o2, Collections.unmodifiableSet(ignorePaths), vistPath);
    }

    private static boolean objEquals(JSONObject o1, JSONObject o2, Set<String> ignorePaths, StringBuffer vistPath) {
        for (Map.Entry entry1 : o1.entrySet()) {
            Object prop2 = o2.get(entry1.getKey());
            if (JsonUtil.compareEqual(entry1.getValue(), prop2, ignorePaths, new StringBuffer(vistPath).append("/").append((String)entry1.getKey()))) continue;
            return false;
        }
        return true;
    }

    private static boolean compareEqual(Object prop1, Object prop2, Set<String> ignorePaths, StringBuffer vistPath) {
        if (ignorePaths.contains(vistPath.toString())) {
            return true;
        }
        if (prop2 instanceof JSONObject && prop1 instanceof JSONObject) {
            if (!JsonUtil.objEquals((JSONObject)prop1, (JSONObject)prop2, ignorePaths, vistPath)) {
                return false;
            }
        } else if (prop2 instanceof JSONArray && prop1 instanceof JSONArray) {
            JSONArray a1 = (JSONArray)prop1;
            JSONArray a2 = (JSONArray)prop2;
            if (a1.size() != a2.size()) {
                return false;
            }
            for (int i = 0; i < a1.size(); ++i) {
                if (JsonUtil.compareEqual(a1.get(i), a2.get(i), ignorePaths, new StringBuffer(vistPath).append("[]"))) continue;
                return false;
            }
        } else if (!prop2.equals(prop1)) {
            return false;
        }
        return true;
    }

    public static String toString(Object json, boolean prettyFormat) {
        ArrayList features = Lists.newArrayList((Object[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
        if (prettyFormat) {
            features.add(SerializerFeature.PrettyFormat);
        }
        return JSON.toJSONString((Object)json, (SerializerFeature[])features.toArray(new SerializerFeature[features.size()]));
    }

    public static String toString(Object json) {
        return JsonUtil.toString(json, TisAppLaunch.isTestMock());
    }

    public static void assertJSONEqual(Class<?> invokeClass, String assertFileName, DescriptorsJSONResult actual, IAssert azzert) {
        JsonUtil.assertJSONEqual(invokeClass, assertFileName, JsonUtil.toString(actual, true), azzert);
    }

    public static void assertJSONEqual(Class<?> invokeClass, String assertFileName, String actual, IAssert azzert) {
        JsonUtil.assertJSONEqual(invokeClass, assertFileName, JSON.parseObject((String)actual), azzert);
    }

    public static JSONObject loadJSON(Class<?> invokeClass, String fileName) {
        return JSON.parseObject((String)IOUtils.loadResourceFromClasspath(invokeClass, fileName));
    }

    public static void assertJSONEqual(Class<?> invokeClass, String assertFileName, JSONObject actual, IAssert azzert) {
        String expectJson = JSON.toJSONString((Object)JsonUtil.loadJSON(invokeClass, assertFileName), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.PrettyFormat, SerializerFeature.MapSortField});
        System.out.println(assertFileName + "\n" + expectJson);
        String actualJson = JSON.toJSONString((Object)actual, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.PrettyFormat, SerializerFeature.MapSortField});
        azzert.assertEquals("assertFile:" + assertFileName, expectJson, actualJson);
    }

    public static interface IAssert {
        public void assertEquals(String var1, String var2, String var3);
    }
}

