/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.sql.parser;

import com.alibaba.fastjson.JSONObject;
import com.qlangtech.tis.fullbuild.indexbuild.IDumpTable;
import com.qlangtech.tis.fullbuild.indexbuild.IPartionableWarehouse;
import com.qlangtech.tis.order.center.IJoinTaskContext;
import com.qlangtech.tis.plugin.ds.ColMeta;
import com.qlangtech.tis.plugin.ds.IDBReservedKeys;
import com.qlangtech.tis.sql.parser.IAliasTable;
import com.qlangtech.tis.sql.parser.TabPartitions;
import com.qlangtech.tis.sql.parser.er.IPrimaryTabFinder;
import com.qlangtech.tis.sql.parser.meta.DependencyNode;
import com.qlangtech.tis.sql.parser.meta.NodeType;
import com.qlangtech.tis.sql.parser.tuple.creator.EntityName;
import java.text.MessageFormat;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public interface ISqlTask {
    public static final String KEY_ID = "id";
    public static final String KEY_SQL_SCRIPT = "sqlScript";
    public static final String KEY_EXECUTE_TYPE = "executeType";
    public static final String KEY_EXPORT_NAME = "exportName";

    public static JSONObject json(ISqlTask sqlTask) {
        JSONObject task = new JSONObject();
        task.put(KEY_ID, (Object)sqlTask.getId());
        task.put(KEY_SQL_SCRIPT, (Object)sqlTask.getSql());
        task.put(KEY_EXECUTE_TYPE, (Object)NodeType.JOINER_SQL.getType());
        task.put(KEY_EXPORT_NAME, (Object)sqlTask.getExportName());
        return task;
    }

    public static SqlTaskCfg toCfg(JSONObject sqlTask) throws NodeType.NodeTypeParseException {
        SqlTaskCfg taskCfg = new SqlTaskCfg();
        taskCfg.id = sqlTask.getString(KEY_ID);
        taskCfg.sqlScript = sqlTask.getString(KEY_SQL_SCRIPT);
        taskCfg.executeType = NodeType.parse((String)sqlTask.getString(KEY_EXECUTE_TYPE));
        taskCfg.exportName = sqlTask.getString(KEY_EXPORT_NAME);
        return taskCfg;
    }

    public String getId();

    public String getExportName();

    public List<DependencyNode> getDependencies();

    public String getSql();

    public RewriteSql getRewriteSql(String var1, TabPartitions var2, IPartionableWarehouse var3, Supplier<IPrimaryTabFinder> var4, IJoinTaskContext var5, boolean var6);

    public static class RewriteSql {
        private static final MessageFormat SQL_INSERT_TABLE = new MessageFormat("INSERT OVERWRITE TABLE {0} PARTITION (pt,pmod) \n {1}");
        public final String originSql;
        public final String rewriteSql;
        public final IAliasTable primaryTable;
        private final List<ColMeta> cols;

        public List<ColMeta> getCols() {
            if (CollectionUtils.isEmpty(this.cols)) {
                throw new IllegalStateException("cols can not be null");
            }
            return this.cols;
        }

        public List<ColMeta> getColsExcludePartitionCols() {
            return this.getCols().stream().filter(r -> !IDumpTable.preservedPsCols.contains(r.getName())).collect(Collectors.toList());
        }

        public RewriteSql(String originSql, String rewriteSql, List<ColMeta> cols, IAliasTable primaryTable) {
            if (StringUtils.isEmpty((CharSequence)originSql)) {
                throw new IllegalArgumentException("param originSql can not be empty");
            }
            this.originSql = originSql;
            this.rewriteSql = rewriteSql;
            this.primaryTable = primaryTable;
            this.cols = cols;
        }

        public String convert2InsertIntoSQL(IDBReservedKeys dbReservedKeys, String exportTabName) {
            EntityName newCreateTab = EntityName.parse((String)exportTabName);
            return SQL_INSERT_TABLE.format(new Object[]{newCreateTab.getFullName(dbReservedKeys.getEscapeChar()), this.rewriteSql});
        }
    }

    public static class SqlTaskCfg {
        private String id;
        private String sqlScript;
        private NodeType executeType;
        private String exportName;

        public String getId() {
            return this.id;
        }

        public String getSqlScript() {
            return this.sqlScript;
        }

        public NodeType getExecuteType() {
            return this.executeType;
        }

        public String getExportName() {
            return this.exportName;
        }
    }
}

