/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.solrj.util;

import com.qlangtech.tis.cloud.ITISCoordinator;
import com.qlangtech.tis.manage.common.TisUTF8;
import com.qlangtech.tis.realtime.utils.NetUtils;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkUtils {
    public static final String ZK_ASSEMBLE_LOG_COLLECT_PATH = "/tis/incr-transfer-group/incr-state-collect";
    public static final int ZK_ASSEMBLE_LOG_COLLECT_PORT = 56432;
    public static final String ZK_PATH_OVERSEER_ELECT_LEADER = "/overseer_elect/leader";
    private static final Logger logger = LoggerFactory.getLogger(ZkUtils.class);
    public static final String PATH_SPLIT = "/";
    public static Consumer<String> localhostValidator = ip -> {
        if ("127.0.0.1".equals(ip)) {
            throw new IllegalStateException("ip can not be 127.0.0.1");
        }
    };

    public static String getFirstChildValue(ITISCoordinator coordinator, String zkPath) {
        return ZkUtils.getFirstChildValue(coordinator, zkPath, true);
    }

    public static String getFirstChildValue(ITISCoordinator coordinator, String zkPath, boolean onReconnect) {
        if (coordinator == null) {
            throw new IllegalArgumentException("param coordinator can not be null");
        }
        List<String> children = coordinator.getChildren(zkPath, true);
        if (children == null) {
            throw new IllegalStateException("zkPath:" + zkPath + " relevant children can not be null");
        }
        try {
            Iterator<String> iterator;
            if (onReconnect) {
                coordinator.addOnReconnect(() -> ZkUtils.getFirstChildValue(coordinator, zkPath, false));
            }
            if ((iterator = children.iterator()).hasNext()) {
                String c = iterator.next();
                return new String(coordinator.getData(zkPath + PATH_SPLIT + c, true), TisUTF8.get());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        throw new IllegalStateException("zkpath:" + zkPath + " have not find child node");
    }

    public static String registerAddress2ZK(ITISCoordinator zookeeper, String zkPath, int port) throws InterruptedException {
        String ip = NetUtils.getHost();
        ZkUtils.registerMyIp(zkPath, ip, port, zookeeper);
        zookeeper.addOnReconnect(() -> ZkUtils.registerMyIp(zkPath, ip, port, zookeeper));
        return ip;
    }

    public static void registerTemporaryContent(ITISCoordinator zookeeper, String zkPath, String content) throws InterruptedException {
        ZkUtils.registerContent(zkPath, content, zookeeper);
        zookeeper.addOnReconnect(() -> ZkUtils.registerContent(zkPath, content, zookeeper));
    }

    private static void registerContent(String zkpath, String content, ITISCoordinator zookeeper) {
        try {
            String[] pathname = StringUtils.split((String)zkpath, (String)PATH_SPLIT);
            if (pathname.length > 1) {
                StringBuffer path = new StringBuffer();
                ZkUtils.guaranteeExist(zookeeper, path, Arrays.copyOfRange(pathname, 0, pathname.length - 1), 0, "".getBytes());
            }
            zookeeper.create(zkpath, content.getBytes(TisUTF8.get()), false, true);
        }
        catch (Exception e) {
            logger.error(e.getMessage() + "\n zkpath:" + zkpath, (Throwable)e);
            throw new RuntimeException(e.getMessage() + "\n zkpath:" + zkpath, e);
        }
    }

    private static String registerMyIp(String parentNodepath, String ip, int port, ITISCoordinator zookeeper) {
        try {
            localhostValidator.accept((String)ip);
            if (port > 0) {
                ip = (String)ip + ":" + port;
            }
            ZkUtils.registerContent(parentNodepath + "/nodes", (String)ip, zookeeper);
            return ip;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void guaranteeExist(ITISCoordinator zookeeper, String parentNodepath, byte[] data) throws Exception {
        String[] pathname = StringUtils.split((String)parentNodepath, (String)PATH_SPLIT);
        StringBuffer path = new StringBuffer();
        ZkUtils.guaranteeExist(zookeeper, path, pathname, 0, data);
    }

    public static void guaranteeExist(ITISCoordinator zookeeper, String parentNodepath) throws Exception {
        ZkUtils.guaranteeExist(zookeeper, parentNodepath, "".getBytes());
    }

    private static void guaranteeExist(ITISCoordinator zookeeper, StringBuffer path, String[] paths, int deepth, byte[] data) throws Exception {
        if (deepth >= paths.length) {
            return;
        }
        path.append(PATH_SPLIT).append(paths[deepth]);
        if (!zookeeper.exists(path.toString(), false)) {
            zookeeper.create(path.toString(), data, true, false);
        }
        ZkUtils.guaranteeExist(zookeeper, path, paths, ++deepth, data);
    }

    public static void main(String[] args) throws Exception {
        System.out.println("start");
        String[] pathname = new String[]{"a", "b"};
        for (String n : pathname = Arrays.copyOfRange(pathname, 0, pathname.length - 1)) {
            System.out.println(n);
        }
    }
}

