/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.solrdao;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.qlangtech.tis.lang.TisException;
import com.qlangtech.tis.solrdao.ISchemaField;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public interface ISchema {
    public static final Set<String> reserved_words = Sets.newHashSet((Object[])new String[]{"_val_", "fq", "docId", "score", "q", "boost"});
    public static final StringBuffer reservedWordsBuffer = new StringBuffer(reserved_words.stream().map(w -> "'" + w + "'").collect(Collectors.joining(",")));

    public static String getFieldPropRequiredErr(String fieldName) {
        return "\u5b57\u6bb5:\u2018" + fieldName + "\u2019\u7684\u5c5e\u6027'stored'\u6216'indexed'\u6216'docvalue'\u81f3\u5c11\u6709\u4e00\u9879\u4e3atrue";
    }

    public static <T extends ISchemaField> List<String> validateSchema(List<T> fields) {
        ArrayList<String> errlist = new ArrayList<String>();
        ArrayList pks = Lists.newArrayList();
        for (ISchemaField field : fields) {
            String fieldName;
            if (field.isUniqueKey()) {
                pks.add(field.getName());
            }
            if (!(field.isIndexed() || field.isStored() || field.isDocValue())) {
                errlist.add(ISchema.getFieldPropRequiredErr(field.getName()));
            }
            if (!reserved_words.contains(fieldName = StringUtils.lowerCase((String)field.getName()))) continue;
            errlist.add("\u5b57\u6bb5\u540d\u79f0:" + field.getName() + "\u4e0d\u80fd\u547d\u540d\u6210\u7cfb\u7edf\u4fdd\u7559\u5b57\u7b26" + reservedWordsBuffer);
        }
        if (pks.size() < 1) {
            errlist.add("\u8bf7\u4e3a\u5f53\u524dschema\u5b9a\u4e49\u4e3b\u952e\uff08PK\uff09");
        } else if (pks.size() > 1) {
            throw TisException.create("can not define more than 1 pks:" + pks.stream().collect(Collectors.joining(",")));
        }
        return errlist;
    }

    public <TT extends ISchemaField> List<TT> getSchemaFields();

    public String getUniqueKey();

    public String getSharedKey();

    public JSONArray serialTypes();

    public void clearFields();

    public boolean isValid();

    public List<String> getErrors();
}

