/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.solr.common;

import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DOMUtil {
    public static final String XML_RESERVED_PREFIX = "xml";

    public static String getAttr(NamedNodeMap attrs, String name) {
        return DOMUtil.getAttr(attrs, name, null);
    }

    public static String getAttr(Node nd, String name) {
        return DOMUtil.getAttr(nd.getAttributes(), name);
    }

    public static String getAttr(NamedNodeMap attrs, String name, String missing_err) {
        Node attr;
        Node node = attr = attrs == null ? null : attrs.getNamedItem(name);
        if (attr == null) {
            if (missing_err == null) {
                return null;
            }
            throw new RuntimeException(missing_err + ": missing mandatory attribute '" + name + "'");
        }
        String val = attr.getNodeValue();
        return val;
    }

    public static String getAttr(Node node, String name, String missing_err) {
        return DOMUtil.getAttr(node.getAttributes(), name, missing_err);
    }

    public static Map<String, String> toMap(NamedNodeMap attrs) {
        return DOMUtil.toMapExcept(attrs, new String[0]);
    }

    public static Map<String, String> toMapExcept(NamedNodeMap attrs, String ... exclusions) {
        HashMap<String, String> args = new HashMap<String, String>();
        block0: for (int j = 0; j < attrs.getLength(); ++j) {
            Node attr = attrs.item(j);
            if (XML_RESERVED_PREFIX.equals(attr.getPrefix())) continue;
            String attrName = attr.getNodeName();
            for (String ex : exclusions) {
                if (ex.equals(attrName)) continue block0;
            }
            String val = attr.getNodeValue();
            args.put(attrName, val);
        }
        return args;
    }
}

