/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.runtime.module.misc.impl;

import com.alibaba.citrus.turbine.Context;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.qlangtech.tis.runtime.module.misc.IFieldErrorHandler;
import com.qlangtech.tis.runtime.module.misc.impl.ListDetailedItemsErrors;
import com.qlangtech.tis.trigger.util.JsonUtil;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Stack;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class DefaultFieldErrorHandler
implements IFieldErrorHandler {
    private static final Pattern JSONARRAR_TOKEN = Pattern.compile("\\[(\\d+)\\]");
    private static final Pattern JSONOBJECT_TOKEN = Pattern.compile("\\.([_\\dA-Za-z]+)");
    public static final String KEY_VALIDATE_FIELDS_STACK = "validate_fields_stack";
    public static final String KEY_VALIDATE_ITEM_INDEX = "validate_item_index";
    public static final String KEY_VALIDATE_ITEM_SUBITEM_DETAILED_PK_VAL = "validate_item_subitem_detailed_pk_val";
    public static final String KEY_VALIDATE_PLUGIN_INDEX = "validate_plugin_index";

    @Override
    public boolean validateBizLogic(IFieldErrorHandler.BizLogic logicType, Context context, String fieldName, String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IFieldErrorHandler.BasicPipelineValidator getPipelineValidator(IFieldErrorHandler.BizLogic logicType) {
        throw new UnsupportedOperationException();
    }

    public static void pushFieldStack(Context context, String fieldName, int itemIndex) {
        Stack<FieldIndex> fieldStack = (Stack<FieldIndex>)context.get(KEY_VALIDATE_FIELDS_STACK);
        if (fieldStack == null) {
            fieldStack = new Stack<FieldIndex>();
            context.put(KEY_VALIDATE_FIELDS_STACK, fieldStack);
        }
        fieldStack.push(new FieldIndex(fieldName, itemIndex));
    }

    public static Stack<FieldIndex> getFieldStack(Context context) {
        return (Stack)context.get(KEY_VALIDATE_FIELDS_STACK);
    }

    public static void popFieldStack(Context context) {
        Stack fieldStack = (Stack)context.get(KEY_VALIDATE_FIELDS_STACK);
        if (fieldStack == null) {
            return;
        }
        fieldStack.pop();
    }

    @Override
    public final void addFieldError(Context context, String fieldName, String msg, Object ... params) {
        Integer pluginIndex = (Integer)context.get(KEY_VALIDATE_PLUGIN_INDEX);
        Integer itemIndex = (Integer)context.get(KEY_VALIDATE_ITEM_INDEX);
        Optional<String> subItemDetiledPk = Optional.ofNullable((String)context.get(KEY_VALIDATE_ITEM_SUBITEM_DETAILED_PK_VAL));
        Stack<FieldIndex> fieldStack = DefaultFieldErrorHandler.getFieldStack(context);
        itemIndex = itemIndex == null ? 0 : itemIndex;
        pluginIndex = pluginIndex == null ? 0 : pluginIndex;
        List<FieldError> fieldsErrorList = this.getFieldsError(context, fieldStack, pluginIndex, itemIndex, subItemDetiledPk);
        String pkName = DefaultFieldErrorHandler.getKeyFieldName(fieldName);
        Objects.requireNonNull(pkName, "pkName can not be null");
        boolean contain = false;
        for (FieldError fieldError : fieldsErrorList) {
            if (!StringUtils.equals((String)pkName, (String)fieldError.fieldName)) continue;
            fieldError.addMsg(fieldName, msg);
            contain = true;
            break;
        }
        if (!contain) {
            fieldsErrorList.add(new FieldError(fieldName, msg));
        }
    }

    private List<FieldError> getFieldsError(Context context, Stack<FieldIndex> fieldStack, Integer pluginIndex, Integer itemIndex, Optional<String> subItemDetiledPk) {
        List pluginErrorList = null;
        pluginErrorList = (List)context.get("action_error_fields");
        if (pluginErrorList == null) {
            pluginErrorList = Lists.newArrayList();
            context.put("action_error_fields", pluginErrorList);
        }
        List itemsErrorList = this.getFieldErrors(pluginIndex, pluginErrorList, () -> Lists.newArrayList());
        List<FieldError> fieldsErrorList = null;
        if (subItemDetiledPk.isPresent()) {
            SubFromDetailedItemsErrors multiDetailed = (SubFromDetailedItemsErrors)this.getFieldErrors(itemIndex, itemsErrorList, () -> new SubFromDetailedItemsErrors());
            fieldsErrorList = multiDetailed.getDetailedFormError(subItemDetiledPk.get());
        } else {
            ListDetailedItemsErrors fieldErrors = (ListDetailedItemsErrors)this.getFieldErrors(itemIndex, itemsErrorList, () -> new ListDetailedItemsErrors());
            fieldsErrorList = fieldErrors.fieldsErrorList;
        }
        if (fieldStack == null || fieldStack.size() < 1) {
            return fieldsErrorList;
        }
        for (int index = 0; index < fieldStack.size(); ++index) {
            FieldIndex fieldIndex = (FieldIndex)fieldStack.get(index);
            Optional<FieldError> find = fieldsErrorList.stream().filter(f -> StringUtils.equals((String)f.getFieldName(), (String)fieldIndex.filedName)).findFirst();
            FieldError fieldErr = null;
            if (find.isPresent()) {
                fieldErr = find.get();
            } else {
                fieldErr = new FieldError(fieldIndex.filedName, null);
                fieldsErrorList.add(fieldErr);
            }
            if (fieldErr.itemsErrorList == null) {
                fieldErr.itemsErrorList = Lists.newArrayList();
            }
            fieldsErrorList = ((ListDetailedItemsErrors)this.getFieldErrors((Integer)Integer.valueOf((int)fieldIndex.itemIndex), fieldErr.itemsErrorList, (Callable<ItemsErrors>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$getFieldsError$4(), ()Lcom/qlangtech/tis/runtime/module/misc/impl/DefaultFieldErrorHandler$ItemsErrors;)())).fieldsErrorList;
        }
        return fieldsErrorList;
    }

    private <T> T getFieldErrors(Integer itemIndex, List<T> itemsErrorList, Callable<T> newer) {
        try {
            T fieldsErrorList;
            while (itemIndex >= itemsErrorList.size()) {
                fieldsErrorList = newer.call();
                itemsErrorList.add(fieldsErrorList);
            }
            fieldsErrorList = itemsErrorList.get(itemIndex);
            return fieldsErrorList;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static IFieldMsg setVal(JSONObject json, String complexPropKey, String val) {
        return DefaultFieldErrorHandler.setVal(json, complexPropKey, val, Optional.empty());
    }

    static String getKeyFieldName(String jsonPathFieldName) {
        StrFieldMsg keyFieldName = (StrFieldMsg)DefaultFieldErrorHandler.setVal(null, jsonPathFieldName, null, (String primaryKeyName) -> new StrFieldMsg((String)primaryKeyName));
        return keyFieldName.msg;
    }

    static IFieldMsg setVal(JSONObject json, String complexPropKey, String val, Function<String, IFieldMsg> primaryKeyConsumer) {
        return DefaultFieldErrorHandler.setVal(json, complexPropKey, val, Optional.of(primaryKeyConsumer));
    }

    private static void println(String msg) {
    }

    private static IFieldMsg setVal(JSONObject json, String complexPropKey, String val, Optional<Function<String, IFieldMsg>> primaryKeyConsumer) {
        Matcher arrayMatcher = JSONARRAR_TOKEN.matcher(complexPropKey);
        Matcher objMatcher = JSONOBJECT_TOKEN.matcher(complexPropKey);
        int matchStart = 0;
        if (!primaryKeyConsumer.isPresent() && json == null) {
            json = new JSONObject();
        }
        TailObj tailObj = null;
        boolean turn = true;
        while (matchStart < complexPropKey.length()) {
            int arrayMatchStart = -1;
            int objectMatchStart = -1;
            if (arrayMatcher.find(matchStart)) {
                DefaultFieldErrorHandler.println("---->" + arrayMatcher.group(1) + ",start:" + arrayMatcher.start());
                arrayMatchStart = arrayMatcher.start();
            }
            if (objMatcher.find(matchStart)) {
                DefaultFieldErrorHandler.println("---->" + objMatcher.group() + ",start:" + objMatcher.start());
                objectMatchStart = objMatcher.start();
            }
            if (arrayMatchStart > -1 && (objectMatchStart < 0 || arrayMatchStart < objectMatchStart)) {
                String arrayToken = StringUtils.substring((String)complexPropKey, (int)matchStart, (int)arrayMatchStart);
                if (StringUtils.isEmpty((String)arrayToken)) {
                    DefaultFieldErrorHandler.println("arrayIndex:" + arrayMatcher.group(1));
                    tailObj = tailObj.addArray(Integer.parseInt(arrayMatcher.group(1)));
                } else {
                    if (primaryKeyConsumer.isPresent()) {
                        return primaryKeyConsumer.get().apply(arrayToken);
                    }
                    int indexOf = Integer.parseInt(arrayMatcher.group(1));
                    DefaultFieldErrorHandler.println("arrayMatch:" + arrayToken + ",arrayIndex:" + indexOf);
                    JSONArray array = null;
                    if (json.containsKey((Object)arrayToken)) {
                        array = json.getJSONArray(arrayToken);
                    } else {
                        array = new JSONArray();
                        json.put(arrayToken, (Object)array);
                    }
                    tailObj = new TailObjOfArray(array, indexOf);
                }
                matchStart = arrayMatcher.end();
                continue;
            }
            if (objectMatchStart > -1 && (arrayMatchStart < 0 || arrayMatchStart > objectMatchStart)) {
                String objToken = objMatcher.group(1);
                String obj = StringUtils.substring((String)complexPropKey, (int)matchStart, (int)objMatcher.start());
                DefaultFieldErrorHandler.println("pre:" + obj + ",objMatch:" + objToken + ",matchStart:" + objMatcher.start());
                matchStart = objMatcher.end();
                if (StringUtils.isNotEmpty((String)obj)) {
                    if (primaryKeyConsumer.isPresent()) {
                        return primaryKeyConsumer.get().apply(obj);
                    }
                    JSONObject newObj = null;
                    if (json.containsKey((Object)obj)) {
                        Object j = json.get((Object)obj);
                        if (!(j instanceof JSONObject)) {
                            throw new IllegalStateException("json obj key:" + obj + " relevant element:\n" + JsonUtil.toString(j) + "\n must be type of :" + JSONObject.class.getSimpleName());
                        }
                        newObj = (JSONObject)j;
                    } else {
                        newObj = new JSONObject();
                        json.put(obj, (Object)newObj);
                    }
                    tailObj = new TailOfObject(newObj, objToken);
                    continue;
                }
                tailObj = tailObj.addObj(objToken);
                continue;
            }
            if (primaryKeyConsumer.isPresent()) {
                return primaryKeyConsumer.get().apply(complexPropKey);
            }
            return new StrFieldMsg(val);
        }
        tailObj.finalSetVal(val);
        return new JSONFieldErrorMsg(json);
    }

    private static /* synthetic */ ItemsErrors lambda$getFieldsError$4() throws Exception {
        return new ListDetailedItemsErrors();
    }

    public static class FieldIndex {
        public final String filedName;
        public final int itemIndex;

        public FieldIndex(String filedName, int itemIndex) {
            this.filedName = filedName;
            this.itemIndex = itemIndex;
        }
    }

    static class TailOfObject
    extends TailObj {
        private final JSONObject obj;
        private final String key;

        public TailOfObject(JSONObject obj, String key) {
            this.obj = Objects.requireNonNull(obj, "obj can not be null");
            this.key = key;
        }

        @Override
        public TailObj addArray(int index) {
            JSONArray array = null;
            array = this.obj.getJSONArray(this.key);
            if (array == null) {
                array = new JSONArray();
                this.obj.put(this.key, (Object)array);
            }
            return new TailObjOfArray(array, index);
        }

        @Override
        public TailObj addObj(String objToken) {
            JSONObject newObj = null;
            newObj = this.obj.getJSONObject(this.key);
            if (newObj == null) {
                newObj = new JSONObject();
                this.obj.put(this.key, (Object)newObj);
            }
            return new TailOfObject(newObj, objToken);
        }

        @Override
        public void finalSetVal(String val) {
            this.obj.put(this.key, (Object)val);
        }
    }

    static class TailObjOfArray
    extends TailObj {
        JSONArray array = new JSONArray();
        int indexOf;

        public TailObjOfArray(JSONArray array, int indexOf) {
            this.array = Objects.requireNonNull(array);
            this.indexOf = indexOf;
            if (indexOf >= array.size()) {
                array.set(indexOf, null);
            }
        }

        @Override
        public TailObj addArray(int index) {
            JSONArray newArray = null;
            newArray = this.array.getJSONArray(this.indexOf);
            if (newArray == null) {
                newArray = new JSONArray();
                this.array.set(this.indexOf, (Object)newArray);
            }
            return new TailObjOfArray(Objects.requireNonNull(newArray, "newArray can not be null"), index);
        }

        @Override
        public TailObj addObj(String objToken) {
            JSONObject obj = null;
            obj = this.array.getJSONObject(this.indexOf);
            if (obj == null) {
                obj = new JSONObject();
                this.array.set(this.indexOf, (Object)obj);
            }
            return new TailOfObject(obj, objToken);
        }

        @Override
        public void finalSetVal(String val) {
            this.array.set(this.indexOf, (Object)val);
        }
    }

    static abstract class TailObj {
        TailObj() {
        }

        public abstract TailObj addArray(int var1);

        public abstract TailObj addObj(String var1);

        public abstract void finalSetVal(String var1);
    }

    private static class JSONFieldErrorMsg
    implements IFieldMsg {
        private final JSONObject content;

        public JSONFieldErrorMsg(JSONObject content) {
            this.content = content;
        }

        @Override
        public Object getContent() {
            Iterator iterator = this.content.entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                return entry.getValue();
            }
            throw new IllegalStateException("can not find content from content:\n" + JsonUtil.toString(this.content));
        }

        @Override
        public void addNestMsg(String nestKey, String val) {
            DefaultFieldErrorHandler.setVal(this.content, nestKey, val);
        }
    }

    private static class StrFieldMsg
    implements IFieldMsg {
        private final String msg;

        public StrFieldMsg(String msg) {
            this.msg = msg;
        }

        @Override
        public Object getContent() {
            return this.msg;
        }

        @Override
        public void addNestMsg(String nestKey, String val) {
        }
    }

    public static interface IFieldMsg {
        public Object getContent();

        public void addNestMsg(String var1, String var2);
    }

    public static class FieldError {
        private final String fieldName;
        private final IFieldMsg msg;
        public List<ItemsErrors> itemsErrorList;

        public FieldError(String fieldName, String msg) {
            this.fieldName = DefaultFieldErrorHandler.getKeyFieldName(fieldName);
            this.msg = DefaultFieldErrorHandler.setVal(null, fieldName, msg);
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public void addMsg(String nestKey, String val) {
            this.msg.addNestMsg(nestKey, val);
        }

        public Object getMsg() {
            return this.msg.getContent();
        }
    }

    private static class SubFromDetailedItemsErrors
    extends ItemsErrors {
        private Map<String, List<FieldError>> multiDetailed = Maps.newHashMap();

        private SubFromDetailedItemsErrors() {
        }

        List<FieldError> getDetailedFormError(String subItemDetiledPk) {
            if (StringUtils.isEmpty((String)subItemDetiledPk)) {
                throw new IllegalArgumentException("param subItemDetiledPk can not be null");
            }
            ArrayList fieldsErrorList = this.multiDetailed.get(subItemDetiledPk);
            if (fieldsErrorList == null) {
                fieldsErrorList = Lists.newArrayList();
                this.multiDetailed.put(subItemDetiledPk, fieldsErrorList);
            }
            return fieldsErrorList;
        }

        @Override
        public JSON serial2JSON() {
            JSONObject errors = new JSONObject();
            for (Map.Entry<String, List<FieldError>> entry : this.multiDetailed.entrySet()) {
                errors.put(entry.getKey(), (Object)ListDetailedItemsErrors.convertItemsErrorList(entry.getValue()));
            }
            return errors;
        }
    }

    public static abstract class ItemsErrors {
        public abstract JSON serial2JSON();
    }
}

