/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.runtime.module.misc;

import com.google.common.collect.ImmutableMap;
import com.qlangtech.tis.plugin.ds.ReflectSchemaFieldType;
import com.qlangtech.tis.runtime.module.misc.ISearchEngineTokenizerType;
import com.qlangtech.tis.runtime.module.misc.VisualType;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public enum TokenizerType implements ISearchEngineTokenizerType
{
    NULL(ReflectSchemaFieldType.STRING.literia, "\u65e0\u5206\u8bcd"),
    IK(ReflectSchemaFieldType.IK.literia, "IK\u5206\u8bcd"),
    LIKE(ReflectSchemaFieldType.LIKE.literia, "LIKE\u5206\u8bcd"),
    BLANK_SPLIT(ReflectSchemaFieldType.TEXT_WS.literia, "\u7a7a\u683c\u5206\u8bcd"),
    PINGYIN(ReflectSchemaFieldType.PINYIN.literia, "\u62fc\u97f3\u5206\u8bcd");

    public static final Map<String, VisualType> visualTypeMap;
    private final String key;
    private final String desc;

    private static void addNumericType(ImmutableMap.Builder<String, VisualType> visualTypeMapBuilder, String numericType) {
        VisualType type = new VisualType(numericType, false);
        visualTypeMapBuilder.put((Object)("p" + numericType), (Object)type);
    }

    public static boolean isContain(String key) {
        return TokenizerType.parseVisualType(key) != null;
    }

    public static VisualType parseVisualType(String key) {
        VisualType result = visualTypeMap.get(key);
        if (result != null) {
            return result;
        }
        for (TokenizerType type : TokenizerType.values()) {
            if (!StringUtils.equals((String)type.getKey(), (String)key)) continue;
            return VisualType.STRING_TYPE;
        }
        return null;
    }

    public static TokenizerType parse(String key) {
        for (TokenizerType type : TokenizerType.values()) {
            if (!StringUtils.equals((String)type.key, (String)key)) continue;
            return type;
        }
        return null;
    }

    private TokenizerType(String key, String desc) {
        this.key = key;
        this.desc = desc;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }

    static {
        ImmutableMap.Builder visualTypeMapBuilder = new ImmutableMap.Builder();
        visualTypeMapBuilder.put((Object)ReflectSchemaFieldType.STRING.literia, (Object)VisualType.STRING_TYPE);
        TokenizerType.addNumericType((ImmutableMap.Builder<String, VisualType>)visualTypeMapBuilder, ReflectSchemaFieldType.DOUBLE.literia);
        TokenizerType.addNumericType((ImmutableMap.Builder<String, VisualType>)visualTypeMapBuilder, ReflectSchemaFieldType.INT.literia);
        TokenizerType.addNumericType((ImmutableMap.Builder<String, VisualType>)visualTypeMapBuilder, ReflectSchemaFieldType.FLOAT.literia);
        TokenizerType.addNumericType((ImmutableMap.Builder<String, VisualType>)visualTypeMapBuilder, ReflectSchemaFieldType.LONG.literia);
        visualTypeMap = visualTypeMapBuilder.build();
    }
}

