/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.realtime.yarn.rpc;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class PipelineFlinkTaskId {
    private final String pipeline;
    private final String taskId;

    public static final PipelineFlinkTaskId parse(String key) {
        String[] split = StringUtils.split((String)key, (String)"$");
        if (split.length != 2) {
            throw new IllegalArgumentException("key:" + key + " is not invalid");
        }
        return new PipelineFlinkTaskId(split[0], split[1]);
    }

    public PipelineFlinkTaskId(String pipeline, String taskId) {
        if (StringUtils.isEmpty((CharSequence)pipeline)) {
            throw new IllegalArgumentException("illegal param pipeline");
        }
        if (StringUtils.isEmpty((CharSequence)taskId)) {
            throw new IllegalArgumentException("illegal param taskId");
        }
        this.pipeline = pipeline;
        this.taskId = taskId;
    }

    public String getPipeline() {
        return this.pipeline;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getKey() {
        return this.pipeline + "$" + this.taskId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PipelineFlinkTaskId that = (PipelineFlinkTaskId)o;
        return Objects.equals(this.pipeline, that.pipeline) && Objects.equals(this.taskId, that.taskId);
    }

    public int hashCode() {
        return Objects.hash(this.pipeline, this.taskId);
    }
}

