/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.realtime.yarn.rpc;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.qlangtech.tis.manage.common.Config;
import com.qlangtech.tis.manage.common.ConfigFileContext;
import com.qlangtech.tis.manage.common.HttpUtils;
import com.qlangtech.tis.manage.common.PostFormStreamProcess;
import com.qlangtech.tis.manage.common.TisUTF8;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public enum JobType {
    IndexJobRunning(1, "JobRunning"),
    QueryIndexJobRunningStatus(2, "QueryIncrStatus"),
    Collection_TopicTags_status(3, "collection_topic_tags_status"),
    ACTION_getTopicTags(4, "get_topic_tags"),
    PipelineDelete(5, "pipeline_delete");

    private final int value;
    private final String name;
    private final ConfigFileContext.HTTPMethod method;
    private static final String KEY_BIZ = "biz";

    public int getValue() {
        return this.value;
    }

    private JobType(int value, String name) {
        this(value, name, ConfigFileContext.HTTPMethod.POST);
    }

    private JobType(int value, String name, ConfigFileContext.HTTPMethod method) {
        this.value = value;
        this.name = name;
        this.method = method;
    }

    public String getName() {
        return this.name;
    }

    public static JobType parseJobType(int value) {
        for (JobType jt : JobType.values()) {
            if (jt.value != value) continue;
            return jt;
        }
        throw new IllegalArgumentException("value:" + value + " is not illegal");
    }

    public static JobType parseJobType(String name) {
        for (JobType jt : JobType.values()) {
            if (!jt.name.equals(name)) continue;
            return jt;
        }
        throw new IllegalArgumentException("name:" + name + " is not illegal");
    }

    public <T> RemoteCallResult<T> assembIncrControlWithResult(String collectionName, List<HttpUtils.PostParam> extraParams, final Class<T> clazz) throws MalformedURLException {
        return this.assembIncrControl(collectionName, extraParams, clazz == null ? null : new IAssembIncrControlResult(){

            @Override
            public T deserialize(JSONObject json) {
                return JSON.toJavaObject((JSON)json, (Class)clazz);
            }
        });
    }

    public <T> RemoteCallResult<T> assembIncrControl(String collectionName, List<HttpUtils.PostParam> extraParams, final IAssembIncrControlResult deserialize) throws MalformedURLException {
        String getAssembleHttpHost = Config.getAssembleHttpHost();
        if (StringUtils.isEmpty((CharSequence)getAssembleHttpHost)) {
            throw new IllegalArgumentException("param getAssembleHttpHost can not be empty");
        }
        if (StringUtils.isEmpty((CharSequence)collectionName)) {
            throw new IllegalArgumentException("param collectionName can not be empty");
        }
        URL applyUrl = new URL(getAssembleHttpHost + "/incr-control");
        ArrayList params = Lists.newArrayList();
        params.add(new HttpUtils.PostParam("collection", collectionName));
        params.add(new HttpUtils.PostParam("action", this.getName()));
        params.addAll(extraParams);
        return HttpUtils.process(applyUrl, params, new PostFormStreamProcess<RemoteCallResult>(){

            @Override
            public RemoteCallResult p(int status, InputStream stream, Map<String, List<String>> headerFields) {
                RemoteCallResult result = new RemoteCallResult();
                try {
                    JSONObject j = JSON.parseObject((String)IOUtils.toString((InputStream)stream, (Charset)TisUTF8.get()));
                    result.success = j.getBoolean("success");
                    result.msg = j.getString("msg");
                    if (deserialize != null && j.containsKey((Object)JobType.KEY_BIZ)) {
                        result.biz = deserialize.deserialize(j.getJSONObject(JobType.KEY_BIZ));
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return result;
            }
        }, Objects.requireNonNull(this.method, "method can not be null"));
    }

    public static class RemoteCallResult<T> {
        public boolean success;
        public String msg;
        public T biz;
    }

    public static interface IAssembIncrControlResult {
        public <T> T deserialize(JSONObject var1);
    }
}

