/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.realtime.transfer;

import com.qlangtech.tis.realtime.transfer.CounterType;
import com.qlangtech.tis.realtime.transfer.IIncreaseCounter;
import com.qlangtech.tis.realtime.transfer.ITableFocuseGetter;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;

public abstract class MonitorSysTagMarker {
    public static final int FalconSendTimeStep = 60;
    public static final String KEY_LACK_SOLR_RECORD = "lackSolrRecord";
    private static final String KEY_LACK_SOLR_RECORD_METRIC = "lackrecord";

    public abstract boolean match(String var1);

    public abstract boolean shallCollectByMonitorSystem();

    public abstract String getTags(String var1);

    public abstract String getFalconMetric();

    public static MonitorSysTagMarker[] createMonitorSysTagMarker(final ITableFocuseGetter tableGetter) {
        if (tableGetter == null) {
            throw new IllegalArgumentException("param 'tableFocuse' can not be null");
        }
        return new MonitorSysTagMarker[]{new ConsumeTagMarker(), new SolrUpdateTagMarker(), new TableTagMarker(){

            @Override
            public boolean match(String metricName) {
                return tableGetter.getFocusedTabs().contains(metricName);
            }
        }, new LackSolrRecordTagMarker(), new DefaultMonitorSysTagMarker()};
    }

    public static MonitorSysTagMarker[] createMonitorSysTagMarker(Set<String> focuse) {
        return new MonitorSysTagMarker[0];
    }

    public static JSONObject addMetric(String hostName, long timestamp, String collection, String metricName, long value, CounterType counterType) {
        return MonitorSysTagMarker.addMetric(hostName, timestamp, collection, metricName, value, counterType, null);
    }

    public static JSONObject addMetric(String hostName, long timestamp, String collection, String metricName, long value, CounterType counterType, IIncreaseCounter counter) {
        MonitorSysTagMarker tagMarker = null;
        JSONObject o = new JSONObject();
        if (counter != null && (tagMarker = counter.getMonitorTagMarker()) != null) {
            o.put("metric", (Object)tagMarker.getFalconMetric());
        } else {
            o.put("metric", (Object)metricName);
        }
        o.put("endpoint", (Object)hostName);
        o.put("timestamp", timestamp);
        o.put("value", value);
        o.put("step", 60);
        o.put("counterType", (Object)counterType.getValue());
        String tags = "index=" + collection;
        String tag = null;
        if (tagMarker != null && (tag = tagMarker.getTags(metricName)) != null) {
            tags = tags + "," + tag;
        }
        o.put("tags", (Object)tags);
        return o;
    }

    public static void main(String[] args) throws Exception {
    }

    private static class SolrUpdateTagMarker
    extends MonitorSysTagMarker {
        private static final String FalconMetric = "solrupdate";

        private SolrUpdateTagMarker() {
        }

        @Override
        public boolean match(String metricName) {
            return "solrConsume".equals(metricName);
        }

        @Override
        public String getFalconMetric() {
            return FalconMetric;
        }

        @Override
        public boolean shallCollectByMonitorSystem() {
            return true;
        }

        @Override
        public String getTags(String metricName) {
            return null;
        }
    }

    private static class LackSolrRecordTagMarker
    extends MonitorSysTagMarker {
        private LackSolrRecordTagMarker() {
        }

        @Override
        public boolean match(String metricName) {
            return MonitorSysTagMarker.KEY_LACK_SOLR_RECORD.equals(metricName);
        }

        @Override
        public String getFalconMetric() {
            return MonitorSysTagMarker.KEY_LACK_SOLR_RECORD_METRIC;
        }

        @Override
        public boolean shallCollectByMonitorSystem() {
            return true;
        }

        @Override
        public String getTags(String metricName) {
            return null;
        }
    }

    private static abstract class TableTagMarker
    extends MonitorSysTagMarker {
        private static final String TAGS = "tab=";
        private static final String FalconMetric = "tabs";

        private TableTagMarker() {
        }

        @Override
        public String getFalconMetric() {
            return FalconMetric;
        }

        @Override
        public boolean shallCollectByMonitorSystem() {
            return true;
        }

        @Override
        public String getTags(String metricName) {
            return TAGS + metricName;
        }
    }

    private static class ConsumeTagMarker
    extends MonitorSysTagMarker {
        private static final String TAGS = "type=";
        private static final String FalconMetric = "consume";
        private static final Pattern p = Pattern.compile("consume\\d+");

        private ConsumeTagMarker() {
        }

        @Override
        public String getFalconMetric() {
            return FalconMetric;
        }

        @Override
        public boolean shallCollectByMonitorSystem() {
            return false;
        }

        @Override
        public boolean match(String metricName) {
            Matcher m = p.matcher(metricName);
            return m.matches();
        }

        @Override
        public String getTags(String metricName) {
            return TAGS + metricName;
        }
    }

    private static class DefaultMonitorSysTagMarker
    extends MonitorSysTagMarker {
        private DefaultMonitorSysTagMarker() {
        }

        @Override
        public boolean match(String metricName) {
            return true;
        }

        @Override
        public boolean shallCollectByMonitorSystem() {
            return false;
        }

        @Override
        public String getTags(String metricName) {
            return null;
        }

        @Override
        public String getFalconMetric() {
            return "default";
        }
    }
}

