/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.realtime.transfer;

import com.qlangtech.tis.realtime.yarn.rpc.IncrRateControllerCfgDTO;
import java.util.Optional;

public abstract class ListenerStatusKeeper {
    private int bufferQueueRemainingCapacity;
    private int bufferQueueUsedSize;
    private int consumeErrorCount;
    private int ignoreRowsCount;
    private String uuid;
    private boolean incrProcessPaused;
    private long tis30sAvgRT;

    public boolean isIncrProcessPaused() {
        return this.incrProcessPaused;
    }

    public void setIncrProcessPaused(boolean incrProcessPaused) {
        this.incrProcessPaused = incrProcessPaused;
    }

    public int getBufferQueueRemainingCapacity() {
        return this.bufferQueueRemainingCapacity;
    }

    public void setBufferQueueRemainingCapacity(int bufferQueueRemainingCapacity) {
        this.bufferQueueRemainingCapacity = bufferQueueRemainingCapacity;
    }

    public int getBufferQueueUsedSize() {
        return this.bufferQueueUsedSize;
    }

    public void setBufferQueueUsedSize(int bufferQueueUsedSize) {
        this.bufferQueueUsedSize = bufferQueueUsedSize;
    }

    public int getConsumeErrorCount() {
        return this.consumeErrorCount;
    }

    public void setConsumeErrorCount(int consumeErrorCount) {
        this.consumeErrorCount = consumeErrorCount;
    }

    public int getIgnoreRowsCount() {
        return this.ignoreRowsCount;
    }

    public void setIgnoreRowsCount(int ignoreRowsCount) {
        this.ignoreRowsCount = ignoreRowsCount;
    }

    public String getUUID() {
        return this.uuid;
    }

    public void setUUID(String uuid) {
        this.uuid = uuid;
    }

    private long getTis30sAvgRT() {
        return this.tis30sAvgRT;
    }

    private void setTis30sAvgRT(long tis30sAvgRT) {
        this.tis30sAvgRT = tis30sAvgRT;
    }

    public void setIncrRateLimitConfig(LimitRateTypeAndRatePerSecNums config) {
        this.setTis30sAvgRT(config.serialize());
    }

    public LimitRateTypeAndRatePerSecNums getIncrRateLimitConfig() {
        return LimitRateTypeAndRatePerSecNums.create(this.getTis30sAvgRT());
    }

    public static class LimitRateTypeAndRatePerSecNums {
        private final int perSecRateNums;
        private final Optional<IncrRateControllerCfgDTO.RateControllerType> controllerType;

        public static long serialize(short s, int i) {
            long shortPart = ((long)s & 0xFFFFL) << 48;
            long intPart = ((long)i & 0xFFFFFFFFL) << 16;
            return shortPart | intPart;
        }

        public static short getShort(long composite) {
            return (short)(composite >>> 48);
        }

        public static int getInt(long composite) {
            return (int)(composite >>> 16 & 0xFFFFFFFFL);
        }

        public LimitRateTypeAndRatePerSecNums(IncrRateControllerCfgDTO.RateControllerType controllerType, int perSecRateNums) {
            this.perSecRateNums = perSecRateNums;
            this.controllerType = Optional.ofNullable(controllerType);
        }

        public static LimitRateTypeAndRatePerSecNums create(long gcCounter) {
            int perSecRateNums = LimitRateTypeAndRatePerSecNums.getInt(gcCounter);
            return new LimitRateTypeAndRatePerSecNums(IncrRateControllerCfgDTO.RateControllerType.parse(LimitRateTypeAndRatePerSecNums.getShort(gcCounter)), perSecRateNums);
        }

        public int getPerSecRateNums() {
            return this.perSecRateNums;
        }

        public Optional<IncrRateControllerCfgDTO.RateControllerType> getControllerType() {
            return this.controllerType;
        }

        public long serialize() {
            return LimitRateTypeAndRatePerSecNums.serialize(this.controllerType.map(c -> c.getTypeToken()).orElse(IncrRateControllerCfgDTO.RateControllerType.NoLimitParam.getTypeToken()), this.perSecRateNums);
        }

        public static void main(String[] args) {
            short originalShort = -12345;
            int originalInt = -1412623820;
            long composite = LimitRateTypeAndRatePerSecNums.serialize(originalShort, originalInt);
            System.out.println("Composite long: 0x" + Long.toHexString(composite));
            short extractedShort = LimitRateTypeAndRatePerSecNums.getShort(composite);
            int extractedInt = LimitRateTypeAndRatePerSecNums.getInt(composite);
            System.out.println("Original short: " + originalShort + ", Extracted: " + extractedShort);
            System.out.println("Original int: 0x" + Integer.toHexString(originalInt) + ", Extracted: 0x" + Integer.toHexString(extractedInt));
            assert (originalShort == extractedShort);
            assert (originalInt == extractedInt);
        }
    }
}

