/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.realtime.transfer;

import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

public class DTO {
    private Map<String, Object> after = Collections.emptyMap();
    private Map<String, Object> before = Collections.emptyMap();
    private String dbName;
    private String tableName;
    private String physicsTabName;
    private EventType eventType;

    public String getPhysicsTabName() {
        return this.physicsTabName;
    }

    public void setPhysicsTabName(String physicsTabName) {
        this.physicsTabName = physicsTabName;
    }

    public Map<String, Object> getAfter() {
        return this.after;
    }

    public void setAfter(Map<String, Object> after) {
        this.after = after;
    }

    public Map<String, Object> getBefore() {
        return this.before;
    }

    public void setBefore(Map<String, Object> before) {
        this.before = before;
    }

    public String getTargetTable() {
        return this.getTableName();
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @JSONField(serialize=false)
    public EventType getEvent() {
        return this.eventType;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public DTO setEventType(EventType eventType) {
        this.eventType = eventType;
        return this;
    }

    public DTO clone() {
        DTO d = new DTO();
        d.setBefore(Maps.newHashMap(this.getBefore()));
        d.setAfter(Maps.newHashMap(this.getAfter()));
        d.setTableName(this.tableName);
        d.setEventType(this.eventType);
        d.setDbName(this.dbName);
        return d;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("{");
        if (this.after != null) {
            buffer.append("after=" + this.after.entrySet().stream().map(e -> (String)e.getKey() + ":" + e.getValue()).collect(Collectors.joining(",")));
        }
        buffer.append(", execType='" + String.valueOf((Object)this.eventType) + "'");
        buffer.append(", dbName='" + this.dbName + "'");
        buffer.append(", tableName='" + this.tableName + "'");
        buffer.append('}');
        return buffer.toString();
    }

    public static enum EventType {
        UPDATE_BEFORE("UPDATE_BEFORE", "update"),
        UPDATE_AFTER("UPDATE_AFTER", EventType.UPDATE_BEFORE.collapse),
        ADD("INSERT", "insert"),
        DELETE("DELETE", "delete");

        private final String type;
        private final String collapse;

        private EventType(String type, String collapse) {
            this.type = type;
            this.collapse = collapse;
        }

        public static EventType parse(String eventType) {
            for (EventType e : EventType.values()) {
                if (!e.type.equalsIgnoreCase(eventType)) continue;
                return e;
            }
            throw new IllegalStateException("eventType:" + eventType + " is illegal");
        }

        public String getCollapse() {
            return this.collapse;
        }

        public String getTypeName() {
            return this.type;
        }
    }
}

