/*
 * Decompiled with CFR 0.152.
 */
package com.qlangtech.tis.realtime.transfer;

import com.qlangtech.tis.realtime.transfer.IOnsListenerStatus;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasicIncrStatusReport
implements Runnable {
    private boolean closed = false;
    protected final Collection<IOnsListenerStatus> incrChannels;
    private static final Logger logger = LoggerFactory.getLogger(BasicIncrStatusReport.class);

    public BasicIncrStatusReport(Collection<IOnsListenerStatus> incrChannels) {
        this.incrChannels = incrChannels;
    }

    public void setClose() {
        this.closed = true;
    }

    protected boolean isClosed() {
        return this.closed;
    }

    protected abstract void processSnapshot() throws Exception;

    @Override
    public final void run() {
        try {
            while (!this.isClosed()) {
                try {
                    this.processSnapshot();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {}
            }
            for (IOnsListenerStatus l : this.incrChannels) {
                l.cleanLastAccumulator();
            }
            logger.info("server push realtime update session has been terminated");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

